/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.initializer.template;

import ch.admin.bit.jeap.initializer.config.TemplateNotFoundException;
import ch.admin.bit.jeap.initializer.model.ProjectTemplate;
import ch.admin.bit.jeap.initializer.model.TemplateModule;
import ch.admin.bit.jeap.initializer.model.TemplateParameter;
import ch.admin.bit.jeap.initializer.template.TemplateRepository;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class TemplateService {
    private final TemplateRepository templateRepository;

    public ProjectTemplate getTemplate(String templateKey) {
        ProjectTemplate projectTemplate = this.templateRepository.getTemplate(templateKey);
        if (projectTemplate != null) {
            return projectTemplate;
        }
        throw new TemplateNotFoundException(templateKey);
    }

    public List<ProjectTemplate> getProjectTemplates() {
        return ((Stream)this.templateRepository.getTemplateKeys().stream().parallel()).map(this.templateRepository::getTemplate).sorted(Comparator.comparing(ProjectTemplate::getName)).toList();
    }

    public List<TemplateParameter> getTemplateParameters(String selectedTemplateId) {
        return this.getTemplate(selectedTemplateId).getTemplateParameters();
    }

    public List<TemplateParameter> getModuleParameters(String selectedTemplateId, Set<String> selectedModuleIds) {
        return this.getTemplate(selectedTemplateId).getTemplateModules().stream().filter(module -> selectedModuleIds.contains(module.getId())).flatMap(module -> module.getModuleParameters().stream()).sorted(Comparator.comparing(TemplateParameter::getName)).toList();
    }

    public List<TemplateModule> getProjectModules(String selectedTemplateId) {
        return this.getTemplate(selectedTemplateId).getTemplateModules().stream().sorted(Comparator.comparing(TemplateModule::getName)).toList();
    }

    @Generated
    public TemplateService(TemplateRepository templateRepository) {
        this.templateRepository = templateRepository;
    }
}

