/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.initializer.util;

import ch.admin.bit.jeap.initializer.util.FileProcessingException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;

public class TarGzipUtils {
    public static void tarGzipDirectory(Path sourceDirPath, Path outputFile) throws IOException {
        try (TarArchiveOutputStream tarOutputStream = new TarArchiveOutputStream((OutputStream)new GzipCompressorOutputStream(Files.newOutputStream(outputFile, new OpenOption[0])));){
            tarOutputStream.setLongFileMode(3);
            try (Stream<Path> stream = Files.walk(sourceDirPath, new FileVisitOption[0]);){
                stream.filter(path -> !Files.isDirectory(path, new LinkOption[0])).forEach(path -> TarGzipUtils.addEntry(sourceDirPath, path, tarOutputStream));
            }
        }
    }

    private static void addEntry(Path sourceDirPath, Path path, TarArchiveOutputStream tarOutputStream) {
        try {
            TarArchiveEntry tarEntry = new TarArchiveEntry(path.toFile(), sourceDirPath.relativize(path).toString());
            Set<PosixFilePermission> permissions = Files.getPosixFilePermissions(path, new LinkOption[0]);
            int mode = TarGzipUtils.toOctalMode(permissions);
            tarEntry.setMode(mode);
            tarOutputStream.putArchiveEntry(tarEntry);
            Files.copy(path, (OutputStream)tarOutputStream);
            tarOutputStream.closeArchiveEntry();
        }
        catch (IOException e) {
            throw FileProcessingException.ioException("Error while creating tar.gz file: " + String.valueOf(path), e);
        }
    }

    private static int toOctalMode(Set<PosixFilePermission> permissions) {
        int mode = 0;
        if (permissions.contains((Object)PosixFilePermission.OWNER_READ)) {
            mode |= 0x100;
        }
        if (permissions.contains((Object)PosixFilePermission.OWNER_WRITE)) {
            mode |= 0x80;
        }
        if (permissions.contains((Object)PosixFilePermission.OWNER_EXECUTE)) {
            mode |= 0x40;
        }
        if (permissions.contains((Object)PosixFilePermission.GROUP_READ)) {
            mode |= 0x20;
        }
        if (permissions.contains((Object)PosixFilePermission.GROUP_WRITE)) {
            mode |= 0x10;
        }
        if (permissions.contains((Object)PosixFilePermission.GROUP_EXECUTE)) {
            mode |= 8;
        }
        if (permissions.contains((Object)PosixFilePermission.OTHERS_READ)) {
            mode |= 4;
        }
        if (permissions.contains((Object)PosixFilePermission.OTHERS_WRITE)) {
            mode |= 2;
        }
        if (permissions.contains((Object)PosixFilePermission.OTHERS_EXECUTE)) {
            mode |= 1;
        }
        return mode;
    }
}

