/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.initializer.contributor;

import ch.admin.bit.jeap.initializer.contributor.ProjectContributor;
import ch.admin.bit.jeap.initializer.model.ProjectRequest;
import ch.admin.bit.jeap.initializer.model.ProjectTemplate;
import ch.admin.bit.jeap.initializer.util.FileProcessingException;
import ch.admin.bit.jeap.initializer.util.FileUtils;
import io.micrometer.common.util.StringUtils;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ArtifactIdContributor
implements ProjectContributor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ArtifactIdContributor.class);

    @Override
    public void contribute(Path projectRoot, ProjectRequest projectRequest, ProjectTemplate template) {
        if (StringUtils.isBlank((String)template.getArtifactId()) || StringUtils.isBlank((String)projectRequest.getArtifactId())) {
            return;
        }
        ArtifactIdContributor.renameModuleFolders(projectRoot, projectRequest, template);
        FileUtils.replaceInFiles("pom.xml", projectRoot, template.getArtifactId(), projectRequest.getArtifactId());
        FileUtils.replaceInFiles("jenkinsfile(.*)", projectRoot, template.getArtifactId(), projectRequest.getArtifactId());
        FileUtils.replaceInFiles("jeapDeployPipelineConfig.json", projectRoot, template.getArtifactId(), projectRequest.getArtifactId());
        FileUtils.replaceInFiles("jeapBuildPipelineConfig.json(.*)", projectRoot, template.getArtifactId(), projectRequest.getArtifactId());
        FileUtils.replaceInFiles("Dockerfile", projectRoot, template.getArtifactId(), projectRequest.getArtifactId());
        FileUtils.replaceInFiles("angular.json", projectRoot, template.getArtifactId(), projectRequest.getArtifactId());
        FileUtils.replaceInFiles("environment(.*).ts", projectRoot, template.getArtifactId(), projectRequest.getArtifactId());
        FileUtils.replaceInFiles("package(.*).json", projectRoot, template.getArtifactId(), projectRequest.getArtifactId());
        FileUtils.replaceInFiles("proxy.conf.js", projectRoot, template.getArtifactId(), projectRequest.getArtifactId());
        FileUtils.replaceInFiles("de.json", projectRoot, template.getArtifactId(), projectRequest.getArtifactId());
        FileUtils.replaceInFiles("en.json", projectRoot, template.getArtifactId(), projectRequest.getArtifactId());
        FileUtils.replaceInFiles("fr.json", projectRoot, template.getArtifactId(), projectRequest.getArtifactId());
        FileUtils.replaceInFiles("it.json", projectRoot, template.getArtifactId(), projectRequest.getArtifactId());
        Path runConfigurationsFolder = Path.of(String.valueOf(projectRoot) + "/.idea/runConfigurations", new String[0]);
        if (Files.exists(runConfigurationsFolder, new LinkOption[0])) {
            FileUtils.replaceInFiles("(.*).xml", runConfigurationsFolder, template.getArtifactId(), projectRequest.getArtifactId());
        }
    }

    private static void renameModuleFolders(Path projectRoot, ProjectRequest projectRequest, ProjectTemplate template) {
        try (Stream<Path> stream = Files.walk(projectRoot, new FileVisitOption[0]);){
            List<Path> modules = stream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(path -> path.getFileName().toString().contains(template.getArtifactId())).toList();
            modules.forEach(module -> {
                Path targetPath = Path.of(module.toString().replace(template.getArtifactId(), projectRequest.getArtifactId()), new String[0]);
                try {
                    Files.createDirectories(targetPath, new FileAttribute[0]);
                    Files.move(module, targetPath, StandardCopyOption.ATOMIC_MOVE);
                    log.debug("Renamed module {} to {}", module, (Object)targetPath);
                }
                catch (IOException e) {
                    throw FileProcessingException.ioException(e);
                }
            });
        }
        catch (IOException ioException) {
            throw FileProcessingException.ioException(ioException);
        }
    }

    @Override
    public int getOrder() {
        return -2147483628;
    }
}

