/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.initializer.contributor;

import ch.admin.bit.jeap.initializer.config.JeapInitializerProperties;
import ch.admin.bit.jeap.initializer.contributor.CodeRemoverContributor;
import ch.admin.bit.jeap.initializer.contributor.ProjectContributor;
import ch.admin.bit.jeap.initializer.model.ProjectRequest;
import ch.admin.bit.jeap.initializer.model.ProjectTemplate;
import ch.admin.bit.jeap.initializer.util.FileUtils;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TemplateModuleContributor
implements ProjectContributor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TemplateModuleContributor.class);
    private final Pattern sourceFilesPattern;

    public TemplateModuleContributor(JeapInitializerProperties jeapInitializerProperties) {
        this.sourceFilesPattern = jeapInitializerProperties.getSourceFilesPattern();
    }

    @Override
    public void contribute(Path projectRoot, ProjectRequest projectRequest, ProjectTemplate template) {
        HashSet<String> removedModuleIds = new HashSet<String>(template.getAllModuleIds());
        Set<String> selectedModuleIds = projectRequest.getSelectedModuleIds();
        removedModuleIds.removeAll(selectedModuleIds);
        log.info("Selected modules: {}, removing modules: {}", selectedModuleIds, removedModuleIds);
        removedModuleIds.forEach(moduleId -> this.removeModule((String)moduleId, projectRoot, projectRequest, template));
        selectedModuleIds.forEach(moduleId -> this.removeSelectedModuleMarkers((String)moduleId, projectRoot));
    }

    private void removeModule(String moduleId, Path projectRoot, ProjectRequest projectRequest, ProjectTemplate template) {
        CodeRemoverContributor codeRemoverContributor = new CodeRemoverContributor("MODULE " + moduleId, this.sourceFilesPattern);
        codeRemoverContributor.contribute(projectRoot, projectRequest, template);
        FileUtils.deleteFilesContainingMarker(projectRoot, this.sourceFilesPattern, "MODULE-SPECIFIC FILE FOR MODULE " + moduleId);
    }

    private Pattern moduleSpecificLinePattern(String moduleId) {
        return Pattern.compile(".*(START MODULE %1$s|END MODULE %1$s|MODULE-SPECIFIC FILE FOR MODULE %1$s).*".formatted(moduleId));
    }

    private void removeSelectedModuleMarkers(String moduleId, Path projectRoot) {
        Pattern removedLinePattern = this.moduleSpecificLinePattern(moduleId);
        FileUtils.deleteMatchingLines(projectRoot, this.sourceFilesPattern, removedLinePattern);
    }

    @Override
    public int getOrder() {
        return -2147483643;
    }
}

