/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.initializer.util;

import ch.admin.bit.jeap.initializer.util.FileProcessingException;
import ch.admin.bit.jeap.initializer.util.FileProcessor;
import java.io.IOException;
import java.nio.charset.MalformedInputException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class FileUtils {
    public static void replaceInFiles(String fileNamePatternString, Path projectRoot, String original, String replacement) {
        Pattern fileNamePattern = Pattern.compile(fileNamePatternString, 2);
        FileUtils.walkMatchingFiles(projectRoot, fileNamePattern, matchingFile -> {
            String updatedContent;
            String originalContent = Files.readString(matchingFile);
            if (!originalContent.equals(updatedContent = originalContent.replace(original, replacement))) {
                Files.writeString(matchingFile, (CharSequence)updatedContent, new OpenOption[0]);
            }
        });
    }

    public static void removeRegionInFiles(Pattern fileNamePattern, Path projectRoot, String regionStart, String regionEnd) {
        FileProcessor fileProcessor = file -> {
            List<String> lines = Files.readAllLines(file);
            AtomicBoolean inRegion = new AtomicBoolean(false);
            List<String> updatedLines = lines.stream().filter(line -> {
                if (line.contains(regionStart)) {
                    inRegion.set(true);
                    return false;
                }
                if (line.contains(regionEnd)) {
                    inRegion.set(false);
                    return false;
                }
                return !inRegion.get();
            }).toList();
            if (updatedLines.size() < lines.size()) {
                Files.write(file, updatedLines, new OpenOption[0]);
            }
        };
        FileUtils.walkMatchingFiles(projectRoot, fileNamePattern, fileProcessor);
    }

    public static void deleteFilesContainingMarker(Path projectRoot, Pattern fileNamePattern, String marker) {
        FileProcessor fileProcessor = file -> {
            String content = Files.readString(file);
            if (content.contains(marker)) {
                Files.delete(file);
            }
        };
        FileUtils.walkMatchingFiles(projectRoot, fileNamePattern, fileProcessor);
    }

    public static void walkMatchingFiles(Path projectRoot, Pattern fileNamePattern, FileProcessor fileProcessor) {
        try (Stream<Path> paths = Files.walk(projectRoot, new FileVisitOption[0]);){
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> fileNamePattern.matcher(path.getFileName().toString()).matches()).toList().forEach(matchingFile -> FileUtils.processFile(fileProcessor, matchingFile));
        }
        catch (IOException e) {
            throw FileProcessingException.ioException(e);
        }
    }

    private static void processFile(FileProcessor fileProcessor, Path matchingFile) {
        try {
            fileProcessor.process(matchingFile);
        }
        catch (MalformedInputException malformedInputException) {
        }
        catch (IOException e) {
            throw FileProcessingException.ioException(e);
        }
    }

    public static void deleteMatchingLines(Path projectRoot, Pattern sourceFilesPattern, Pattern removedLinePattern) {
        FileProcessor fileProcessor = file -> {
            List<String> lines = Files.readAllLines(file);
            int size = lines.size();
            lines.removeIf(line -> removedLinePattern.matcher((CharSequence)line).matches());
            if (lines.size() < size) {
                String content = String.join((CharSequence)"\n", lines);
                Files.writeString(file, (CharSequence)content, new OpenOption[0]);
            }
        };
        FileUtils.walkMatchingFiles(projectRoot, sourceFilesPattern, fileProcessor);
    }

    public static void replaceInFilesRegex(Pattern filePattern, Path projectRoot, String regex, String replacement) {
        FileUtils.walkMatchingFiles(projectRoot, filePattern, matchingFile -> {
            String updatedContent;
            String originalContent = Files.readString(matchingFile);
            if (!originalContent.equals(updatedContent = originalContent.replaceAll(regex, replacement))) {
                Files.writeString(matchingFile, (CharSequence)updatedContent, new OpenOption[0]);
            }
        });
    }
}

