/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.initializer.api;

import ch.admin.bit.jeap.initializer.api.model.ProjectTemplateDTO;
import ch.admin.bit.jeap.initializer.generator.ProjectGenerator;
import ch.admin.bit.jeap.initializer.model.ProjectRequest;
import ch.admin.bit.jeap.initializer.template.TemplateService;
import ch.admin.bit.jeap.initializer.util.TarGzipUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.CacheManager;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.FileSystemUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class InitializerController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InitializerController.class);
    private final ProjectGenerator projectGenerator;
    private final TemplateService templateService;
    private final CacheManager cacheManager;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HHmmss");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(summary="Generates a project based on a template", description="Generates a project based on a template")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The project has been successfully generated"), @ApiResponse(responseCode="404", description="The given template has not been found")})
    @PostMapping(value={"/generate"})
    public ResponseEntity<InputStreamResource> generate(@RequestBody ProjectRequest projectRequest) throws IOException {
        log.trace("Generating project with parameters: {}", (Object)projectRequest);
        Path projectFolder = Files.createTempDirectory("jeap-initializer", new FileAttribute[0]);
        try {
            this.projectGenerator.generate(projectRequest, projectFolder);
            Path tarGzipFile = Files.createTempFile("jeapProject", ".tar.gz", new FileAttribute[0]);
            TarGzipUtils.tarGzipDirectory(projectFolder, tarGzipFile);
            InputStreamResource resource = new InputStreamResource(Files.newInputStream(tarGzipFile, new OpenOption[0]));
            HttpHeaders headers = new HttpHeaders();
            headers.add("Content-Disposition", "attachment; filename=\"" + this.generateFileName(projectRequest) + "\"");
            headers.add("Content-Type", "application/gzip");
            ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).contentType(MediaType.APPLICATION_OCTET_STREAM).body((Object)resource);
            return responseEntity;
        }
        finally {
            FileSystemUtils.deleteRecursively((Path)projectFolder);
        }
    }

    @GetMapping(value={"/templates"})
    public List<ProjectTemplateDTO> getProjectTemplates() {
        return this.templateService.getProjectTemplates().stream().map(ProjectTemplateDTO::from).toList();
    }

    @PostMapping(value={"/cache/reset"})
    public void resetTemplateCache() {
        this.cacheManager.getCacheNames().forEach(name -> this.cacheManager.getCache(name).clear());
    }

    private String generateFileName(ProjectRequest projectRequest) {
        return projectRequest.getApplicationName() + this.dateFormat.format(new Date()) + ".tar.gz";
    }

    @Generated
    public InitializerController(ProjectGenerator projectGenerator, TemplateService templateService, CacheManager cacheManager) {
        this.projectGenerator = projectGenerator;
        this.templateService = templateService;
        this.cacheManager = cacheManager;
    }
}

