/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.initializer.ui;

import ch.admin.bit.jeap.initializer.api.InitializerController;
import ch.admin.bit.jeap.initializer.api.model.ProjectTemplateDTO;
import ch.admin.bit.jeap.initializer.api.model.TemplateModuleDTO;
import ch.admin.bit.jeap.initializer.model.ProjectRequest;
import ch.admin.bit.jeap.initializer.model.TemplateParameter;
import ch.admin.bit.jeap.initializer.template.TemplateService;
import ch.admin.bit.jeap.initializer.ui.ProjectRequestFactory;
import ch.admin.bit.jeap.initializer.ui.model.ModuleConfigurationModel;
import ch.admin.bit.jeap.initializer.ui.model.TemplateConfigurationModel;
import ch.admin.bit.jeap.initializer.ui.model.TemplateSelectionModel;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
import java.io.IOException;
import java.util.List;
import lombok.Generated;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/wizard"})
public class WizardController {
    static final String TEMPLATE_LIST = "templateList";
    static final String TEMPLATE_PARAMETERS = "templateParameters";
    static final String MODULE_LIST = "moduleList";
    static final String TEMPLATE_SELECTION_MODEL = "templateSelectionModel";
    static final String TEMPLATE_CONFIGURATION_MODEL = "templateConfigurationModel";
    static final String MODULE_CONFIGURATION_MODEL = "moduleConfigurationModel";
    private final ProjectRequestFactory projectRequestFactory;
    private final TemplateService templateService;
    private final InitializerController initializerController;

    @GetMapping(value={"/step/select-template"})
    public String showStepSelectTemplate(Model model) {
        this.prepareSelectionModelForRendering(model);
        return "wizard-step-select-template";
    }

    @PostMapping(value={"/step/select-template"})
    public String processStepSelectTemplate(@Valid @ModelAttribute(value="templateSelectionModel") TemplateSelectionModel templateSelectionModel, BindingResult bindingResult, Model model, RedirectAttributes redirectAttributes) {
        if (bindingResult.hasErrors()) {
            this.prepareSelectionModelForRendering(model);
            return "wizard-step-select-template";
        }
        redirectAttributes.addAttribute(TEMPLATE_SELECTION_MODEL, (Object)templateSelectionModel);
        return "redirect:/wizard/step/configure-template";
    }

    private void prepareSelectionModelForRendering(Model model) {
        model.addAttribute(TEMPLATE_LIST, this.templateService.getProjectTemplates().stream().map(ProjectTemplateDTO::from).toList());
        if (!model.containsAttribute(TEMPLATE_SELECTION_MODEL)) {
            model.addAttribute(TEMPLATE_SELECTION_MODEL, (Object)new TemplateSelectionModel());
        }
    }

    @GetMapping(value={"/step/configure-template"})
    public String showStepConfigureTemplate(@ModelAttribute(value="templateSelectionModel") TemplateSelectionModel templateSelectionModel, Model model) {
        model.addAttribute(TEMPLATE_SELECTION_MODEL, (Object)templateSelectionModel);
        this.prepareTemplateConfigurationModelForRendering(model, templateSelectionModel);
        return "wizard-step-configure-template";
    }

    @PostMapping(value={"/step/configure-template"})
    public String processStepConfigureTemplate(@Valid @ModelAttribute(value="templateSelectionModel") TemplateSelectionModel templateSelectionModel, @Valid @ModelAttribute(value="templateConfigurationModel") TemplateConfigurationModel templateConfigurationModel, BindingResult bindingResult, HttpServletRequest request, Model model, RedirectAttributes redirectAttributes) {
        List<TemplateParameter> templateParameters = this.templateService.getTemplateParameters(templateSelectionModel.getSelectedTemplateId());
        templateParameters.forEach(templateParameter -> templateConfigurationModel.getTemplateParameterValues().put(templateParameter.getId(), request.getParameter(templateParameter.getId())));
        if (bindingResult.hasErrors()) {
            this.prepareTemplateConfigurationModelForRendering(model, templateSelectionModel);
            return "wizard-step-configure-template";
        }
        redirectAttributes.addAttribute(TEMPLATE_CONFIGURATION_MODEL, (Object)templateConfigurationModel);
        redirectAttributes.addAttribute(TEMPLATE_SELECTION_MODEL, (Object)templateSelectionModel);
        return "redirect:/wizard/step/configure-modules";
    }

    private void prepareTemplateConfigurationModelForRendering(Model model, TemplateSelectionModel templateSelectionModel) {
        String selectedTemplateId = templateSelectionModel.getSelectedTemplateId();
        model.addAttribute(TEMPLATE_PARAMETERS, this.templateService.getTemplateParameters(selectedTemplateId));
        model.addAttribute(MODULE_LIST, this.templateService.getProjectModules(selectedTemplateId).stream().map(TemplateModuleDTO::from).toList());
        if (!model.containsAttribute(TEMPLATE_CONFIGURATION_MODEL)) {
            model.addAttribute(TEMPLATE_CONFIGURATION_MODEL, (Object)new TemplateConfigurationModel());
        }
    }

    @GetMapping(value={"/step/configure-modules"})
    public String showStepConfigureModules(@RequestParam(value="templateSelectionModel") TemplateSelectionModel templateSelectionModel, @RequestParam(value="templateConfigurationModel") TemplateConfigurationModel templateConfigurationModel, Model model, RedirectAttributes redirectAttributes) {
        List<TemplateParameter> moduleParameters = this.templateService.getModuleParameters(templateSelectionModel.getSelectedTemplateId(), templateConfigurationModel.getSelectedModuleIds());
        if (moduleParameters.isEmpty()) {
            redirectAttributes.addAttribute(TEMPLATE_CONFIGURATION_MODEL, (Object)templateConfigurationModel);
            redirectAttributes.addAttribute(TEMPLATE_SELECTION_MODEL, (Object)templateSelectionModel);
            redirectAttributes.addAttribute(MODULE_CONFIGURATION_MODEL, (Object)new ModuleConfigurationModel());
            return "redirect:/wizard/step/review";
        }
        WizardController.prepareModuleConfigurationModelForRendering(model, moduleParameters);
        model.addAttribute(MODULE_CONFIGURATION_MODEL, (Object)new ModuleConfigurationModel());
        model.addAttribute(TEMPLATE_CONFIGURATION_MODEL, (Object)templateConfigurationModel);
        model.addAttribute(TEMPLATE_SELECTION_MODEL, (Object)templateSelectionModel);
        return "wizard-step-configure-modules";
    }

    @PostMapping(value={"/step/configure-modules"})
    public String processStepConfigureModules(@Valid @ModelAttribute(value="templateSelectionModel") TemplateSelectionModel templateSelectionModel, @Valid @ModelAttribute(value="templateConfigurationModel") TemplateConfigurationModel templateConfigurationModel, @Valid @ModelAttribute(value="moduleConfigurationModel") ModuleConfigurationModel moduleConfigurationModel, BindingResult bindingResult, HttpServletRequest request, Model model, RedirectAttributes redirectAttributes) {
        List<TemplateParameter> moduleParameters = this.templateService.getModuleParameters(templateSelectionModel.getSelectedTemplateId(), templateConfigurationModel.getSelectedModuleIds());
        moduleParameters.forEach(moduleParameter -> moduleConfigurationModel.getModuleParameterValues().put(moduleParameter.getId(), request.getParameter(moduleParameter.getId())));
        if (bindingResult.hasErrors()) {
            WizardController.prepareModuleConfigurationModelForRendering(model, moduleParameters);
            return "wizard-step-configure-modules";
        }
        redirectAttributes.addAttribute(TEMPLATE_CONFIGURATION_MODEL, (Object)templateConfigurationModel);
        redirectAttributes.addAttribute(TEMPLATE_SELECTION_MODEL, (Object)templateSelectionModel);
        redirectAttributes.addAttribute(MODULE_CONFIGURATION_MODEL, (Object)moduleConfigurationModel);
        return "redirect:/wizard/step/review";
    }

    private static void prepareModuleConfigurationModelForRendering(Model model, List<TemplateParameter> moduleParameters) {
        model.addAttribute("moduleParameters", moduleParameters);
    }

    @GetMapping(value={"/step/review"})
    public String review(@RequestParam(value="templateSelectionModel") TemplateSelectionModel templateSelectionModel, @RequestParam(value="templateConfigurationModel") TemplateConfigurationModel templateConfigurationModel, @RequestParam(value="moduleConfigurationModel") ModuleConfigurationModel moduleConfigurationModel, Model model) {
        model.addAttribute(TEMPLATE_CONFIGURATION_MODEL, (Object)templateConfigurationModel);
        model.addAttribute(TEMPLATE_SELECTION_MODEL, (Object)templateSelectionModel);
        model.addAttribute(MODULE_CONFIGURATION_MODEL, (Object)moduleConfigurationModel);
        return "wizard-step-review";
    }

    @PostMapping(value={"/step/generate"})
    public ResponseEntity<InputStreamResource> generate(@Valid @ModelAttribute(value="templateSelectionModel") TemplateSelectionModel templateSelectionModel, @Valid @ModelAttribute(value="templateConfigurationModel") TemplateConfigurationModel templateConfigurationModel, @Valid @ModelAttribute(value="moduleConfigurationModel") ModuleConfigurationModel moduleConfigurationModel) throws IOException {
        ProjectRequest projectRequest = this.projectRequestFactory.createProjectRequest(templateSelectionModel, templateConfigurationModel, moduleConfigurationModel);
        return this.initializerController.generate(projectRequest);
    }

    @PostMapping(value={"/reset"})
    public String reset() {
        return "redirect:/wizard/step/select-template";
    }

    @Generated
    public WizardController(ProjectRequestFactory projectRequestFactory, TemplateService templateService, InitializerController initializerController) {
        this.projectRequestFactory = projectRequestFactory;
        this.templateService = templateService;
        this.initializerController = initializerController;
    }
}

