/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messagecontract.domain;

import ch.admin.bit.jeap.messagecontract.persistence.DeploymentRepository;
import ch.admin.bit.jeap.messagecontract.persistence.MessageContractRepository;
import ch.admin.bit.jeap.messagecontract.persistence.model.Deployment;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class DeploymentService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeploymentService.class);
    private final MessageContractRepository messageContractRepository;
    private final DeploymentRepository deploymentRepository;

    @Transactional(readOnly=true)
    public List<Deployment> findLast10Deployments() {
        return this.deploymentRepository.findTop10ByOrderByCreatedAtDesc();
    }

    @Transactional(readOnly=true)
    public List<Deployment> findNewestDeploymentPerAppAndEnv() {
        return this.deploymentRepository.findNewestDeploymentPerAppAndEnv();
    }

    @Transactional
    public Deployment saveNewDeployment(String appName, String appVersion, String environment) {
        if (!this.messageContractRepository.existsByAppNameAndAppVersion(appName, appVersion)) {
            log.info("Application with name '{}' not found in the db. Deployment ignored and not saved", (Object)appName);
            return null;
        }
        Deployment deployment = Deployment.builder().appName(appName).appVersion(appVersion).environment(environment).build();
        return this.deploymentRepository.save(deployment);
    }

    @Transactional
    public void deleteDeployment(String appName, String environment) {
        this.deploymentRepository.deleteDeployment(appName, environment);
    }

    @Generated
    public DeploymentService(MessageContractRepository messageContractRepository, DeploymentRepository deploymentRepository) {
        this.messageContractRepository = messageContractRepository;
        this.deploymentRepository = deploymentRepository;
    }
}

