/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messagecontract.domain.compatibility;

import ch.admin.bit.jeap.messagecontract.domain.compatibility.CompatibilityCheckResult;
import ch.admin.bit.jeap.messagecontract.domain.compatibility.SchemaCompatibilityService;
import ch.admin.bit.jeap.messagecontract.domain.compatibility.SchemaIncompatibility;
import ch.admin.bit.jeap.messagecontract.persistence.DeploymentRepository;
import ch.admin.bit.jeap.messagecontract.persistence.MessageContractRepository;
import ch.admin.bit.jeap.messagecontract.persistence.model.MessageContract;
import io.micrometer.core.annotation.Timed;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class CompatibilityService {
    private final MessageContractRepository messageContractRepository;
    private final SchemaCompatibilityService schemaCompatibilityService;
    private final DeploymentRepository deploymentRepository;

    @Transactional(readOnly=true)
    @Timed(value="checkcompatibility.time", description="Time taken for the compatibility check", histogram=true)
    public CompatibilityCheckResult checkCompatibility(String appName, String appVersion, String environment) {
        List contracts = this.messageContractRepository.getContractsForAppVersion(appName, appVersion);
        return this.checkCompatibilityForContracts(environment, contracts);
    }

    private CompatibilityCheckResult checkCompatibilityForContracts(String environment, List<MessageContract> contracts) {
        ArrayList<CompatibilityCheckResult.ConsumerProducerInteraction> interactions = new ArrayList<CompatibilityCheckResult.ConsumerProducerInteraction>();
        ArrayList<CompatibilityCheckResult.Incompatibility> incompatibilities = new ArrayList<CompatibilityCheckResult.Incompatibility>();
        for (MessageContract contract : contracts) {
            this.checkCompatibilityForContract(environment, interactions, incompatibilities, contract);
        }
        return new CompatibilityCheckResult(interactions, incompatibilities);
    }

    private void checkCompatibilityForContract(String environment, List<CompatibilityCheckResult.ConsumerProducerInteraction> interactions, List<CompatibilityCheckResult.Incompatibility> incompatibilities, MessageContract contract) {
        Set<String> appsInteractedWith = this.getAppNamesInteractedWith(contract);
        for (String appInteractedWith : appsInteractedWith) {
            Optional deployedAppVersionOptional = this.deploymentRepository.findAppVersionCurrentlyDeployedOnEnvironment(appInteractedWith, environment);
            deployedAppVersionOptional.ifPresent(deployedVersion -> this.checkCompatibilityWithApp(interactions, incompatibilities, contract, appInteractedWith, (String)deployedVersion));
        }
    }

    private void checkCompatibilityWithApp(List<CompatibilityCheckResult.ConsumerProducerInteraction> interactions, List<CompatibilityCheckResult.Incompatibility> incompatibilities, MessageContract contract, String appInteractedWith, String deployedVersion) {
        List interactedWithContracts = this.messageContractRepository.getContractsForAppVersionAndMessageTypeOnTopicWithRole(appInteractedWith, deployedVersion, contract.getMessageType(), contract.getTopic(), contract.getRole().opposite());
        for (MessageContract interactedWithContract : interactedWithContracts) {
            CompatibilityCheckResult.ConsumerProducerInteraction interaction = CompatibilityService.createInteraction(appInteractedWith, deployedVersion, interactedWithContract);
            interactions.add(interaction);
            this.validateCompatibility(incompatibilities, contract, interactedWithContract, interaction);
        }
    }

    private void validateCompatibility(List<CompatibilityCheckResult.Incompatibility> incompatibilities, MessageContract appContract, MessageContract interactedWithContract, CompatibilityCheckResult.ConsumerProducerInteraction interaction) {
        List<SchemaIncompatibility> schemaIncompatibilities = this.schemaCompatibilityService.validateCompatibility(appContract, interactedWithContract);
        if (!schemaIncompatibilities.isEmpty()) {
            incompatibilities.add(new CompatibilityCheckResult.Incompatibility(CompatibilityCheckResult.ConsumerProducerInteraction.from(appContract), interaction, schemaIncompatibilities));
        }
    }

    private Set<String> getAppNamesInteractedWith(MessageContract contract) {
        return this.messageContractRepository.distinctAppNameByRoleForMessageTypeOnTopic(contract.getMessageType(), contract.getTopic(), contract.getRole().opposite());
    }

    private static CompatibilityCheckResult.ConsumerProducerInteraction createInteraction(String appInteractedWith, String deployedVersion, MessageContract interactedWithContract) {
        return new CompatibilityCheckResult.ConsumerProducerInteraction(appInteractedWith, deployedVersion, interactedWithContract.getMessageType(), interactedWithContract.getMessageTypeVersion(), interactedWithContract.getTopic(), CompatibilityCheckResult.InteractionRole.from(interactedWithContract.getRole()));
    }

    @Generated
    public CompatibilityService(MessageContractRepository messageContractRepository, SchemaCompatibilityService schemaCompatibilityService, DeploymentRepository deploymentRepository) {
        this.messageContractRepository = messageContractRepository;
        this.schemaCompatibilityService = schemaCompatibilityService;
        this.deploymentRepository = deploymentRepository;
    }
}

