/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messagecontract.domain.compatibility;

import ch.admin.bit.jeap.messagecontract.domain.compatibility.CompatibilityCheckResult;
import ch.admin.bit.jeap.messagecontract.domain.compatibility.SchemaIncompatibility;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.avro.Schema;

class IncompatibilityMessageBuilder {
    IncompatibilityMessageBuilder() {
    }

    public static String build(List<CompatibilityCheckResult.Incompatibility> incompatibilities) {
        if (incompatibilities.isEmpty()) {
            return "No incompatible interactions found";
        }
        return incompatibilities.stream().map(IncompatibilityMessageBuilder::describe).collect(Collectors.joining("\n"));
    }

    private static String describe(CompatibilityCheckResult.Incompatibility incompatibility) {
        String source = IncompatibilityMessageBuilder.describe(incompatibility.source());
        String target = IncompatibilityMessageBuilder.describe(incompatibility.target());
        String incompatibilities = IncompatibilityMessageBuilder.describe(incompatibility.schemaIncompatibilities());
        return "***\n%s, which is incompatible with:\n- %s\n  List of schema incompatibilities:\n%s".formatted(source, target, incompatibilities);
    }

    private static String describe(CompatibilityCheckResult.ConsumerProducerInteraction interaction) {
        return "App %s:%s is %s message type %s:%s on topic %s".formatted(interaction.appName(), interaction.appVersion(), interaction.role().verb(), interaction.messageType(), interaction.messageTypeVersion(), interaction.topic());
    }

    private static String describe(List<SchemaIncompatibility> schemaIncompatibilities) {
        return schemaIncompatibilities.stream().map(schemaIncompatibility -> "  - " + IncompatibilityMessageBuilder.describe(schemaIncompatibility)).collect(Collectors.joining("\n"));
    }

    private static String describe(SchemaIncompatibility schemaIncompatibility) {
        return "%s at %s: %s\n    Schema Fragments (check type name for incompatible type):\n    - Reader: %s\n    - Writer: %s".formatted(schemaIncompatibility.incompatibilityType(), schemaIncompatibility.location(), schemaIncompatibility.message(), IncompatibilityMessageBuilder.toStringOrNoneIfNull(schemaIncompatibility.readerFragment()), IncompatibilityMessageBuilder.toStringOrNoneIfNull(schemaIncompatibility.writerFragment()));
    }

    private static String toStringOrNoneIfNull(Schema schema) {
        return schema == null ? "<none>" : schema.toString();
    }
}

