/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messagecontract.domain.compatibility;

import ch.admin.bit.jeap.messagecontract.domain.compatibility.MessageTypeSchema;
import ch.admin.bit.jeap.messagecontract.domain.compatibility.SchemaIncompatibility;
import ch.admin.bit.jeap.messagecontract.persistence.model.MessageContract;
import ch.admin.bit.jeap.messagecontract.persistence.model.MessageContractRole;
import java.util.List;
import lombok.Generated;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.SchemaCompatibility;
import org.springframework.stereotype.Component;

@Component
public class SchemaCompatibilityService {
    public List<SchemaIncompatibility> validateCompatibility(MessageContract contract, MessageContract interactedWithContract) {
        MessageContract writerContract;
        MessageContract readerContract;
        if (contract.getRole() == MessageContractRole.CONSUMER) {
            readerContract = contract;
            writerContract = interactedWithContract;
        } else {
            readerContract = interactedWithContract;
            writerContract = contract;
        }
        return this.validateCompatibility(MessageTypeSchema.fromMessageContract(readerContract), MessageTypeSchema.fromMessageContract(writerContract));
    }

    List<SchemaIncompatibility> validateCompatibility(MessageTypeSchema readerSchema, MessageTypeSchema writerSchema) {
        Schema writerAvroSchema;
        Schema readerAvroSchema = this.getAvroSchema(readerSchema);
        SchemaCompatibility.SchemaCompatibilityResult result = SchemaCompatibility.checkReaderWriterCompatibility((Schema)readerAvroSchema, (Schema)(writerAvroSchema = this.getAvroSchema(writerSchema))).getResult();
        if (result.getCompatibility() != SchemaCompatibility.SchemaCompatibilityType.COMPATIBLE) {
            return result.getIncompatibilities().stream().map(this::convert).toList();
        }
        return List.of();
    }

    private SchemaIncompatibility convert(SchemaCompatibility.Incompatibility incompatibility) {
        return new SchemaIncompatibility(incompatibility.getType().name(), incompatibility.getMessage(), incompatibility.getReaderFragment(), incompatibility.getWriterFragment(), incompatibility.getLocation());
    }

    private Schema getAvroSchema(MessageTypeSchema schema) {
        Protocol readerProtocol = Protocol.parse((String)schema.avroProtocol());
        return readerProtocol.getType(schema.messageTypeName());
    }

    @Generated
    public SchemaCompatibilityService() {
    }
}

