/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messagecontract.domain.schema;

import ch.admin.bit.jeap.messagecontract.messagetype.repository.MessageTypeRepository;
import ch.admin.bit.jeap.messagecontract.messagetype.repository.MessageTypeRepositoryFactory;
import ch.admin.bit.jeap.messagecontract.persistence.model.MessageContract;
import io.micrometer.core.annotation.Timed;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MessageSchemaService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageSchemaService.class);
    private final MessageTypeRepositoryFactory typeRepositoryFactory;

    @Timed(value="loadschemas.time", description="Time taken to load message type schemas from the registry", histogram=true)
    public void loadSchemas(List<MessageContract> messageContracts) {
        messageContracts.stream().collect(Collectors.groupingBy(MessageContract::getRegistryUrl)).forEach(this::loadSchemasFromRepository);
    }

    private void loadSchemasFromRepository(String registryGitRepoUrl, List<MessageContract> messageContracts) {
        try (MessageTypeRepository messageTypeRepository = this.typeRepositoryFactory.cloneRepository(registryGitRepoUrl);){
            messageContracts.forEach(contract -> this.loadSchemaForMessageType(messageTypeRepository, (MessageContract)contract));
        }
    }

    private void loadSchemaForMessageType(MessageTypeRepository messageTypeRepository, MessageContract messageContract) {
        String schema = this.getSchema(messageContract, messageTypeRepository);
        messageContract.setAvroProtocolSchema(schema);
    }

    private String getSchema(MessageContract messageContract, MessageTypeRepository repository) {
        log.info("Loading message type schema {}:{}", (Object)messageContract.getMessageType(), (Object)messageContract.getMessageTypeVersion());
        return repository.getSchemaAsAvroProtocolJson(messageContract.getBranch(), messageContract.getCommitHash(), messageContract.getMessageType(), messageContract.getMessageTypeVersion());
    }

    @Generated
    public MessageSchemaService(MessageTypeRepositoryFactory typeRepositoryFactory) {
        this.typeRepositoryFactory = typeRepositoryFactory;
    }
}

