/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messagecontract.domain;

import ch.admin.bit.jeap.messagecontract.domain.schema.MessageSchemaService;
import ch.admin.bit.jeap.messagecontract.persistence.MessageContractInfo;
import ch.admin.bit.jeap.messagecontract.persistence.MessageContractRepository;
import ch.admin.bit.jeap.messagecontract.persistence.model.MessageContract;
import ch.admin.bit.jeap.messagecontract.persistence.model.MessageContractRole;
import io.micrometer.core.annotation.Timed;
import jakarta.persistence.EntityManager;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class MessageContractService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageContractService.class);
    private final MessageContractRepository messageContractRepository;
    private final MessageSchemaService messageSchemaService;
    private final EntityManager entityManager;

    @Transactional(readOnly=true)
    public List<MessageContractInfo> getAllContracts() {
        return this.messageContractRepository.findAllMessageContractInfos();
    }

    @Transactional(readOnly=true)
    public List<MessageContractInfo> getContractsForEnvironment(String environment) {
        return this.messageContractRepository.findMessageContractInfosByEnvironment(environment.toUpperCase());
    }

    @Transactional
    @Timed(value="savecontracts.time", description="Time taken to save a contract including its schema", histogram=true)
    public void saveContracts(String appName, String appVersion, String transactionId, List<MessageContract> messageContracts) {
        if (transactionId == null) {
            this.saveContracts(appName, appVersion, messageContracts);
        } else {
            log.debug("Delete contracts for appName={} appVersion={} and not for transactionId={}", new Object[]{appName, appVersion, transactionId});
            int deletedContracts = this.messageContractRepository.deleteByAppNameAndAppVersionNotSameTransactionId(appName, appVersion, transactionId);
            this.entityManager.flush();
            log.debug("Deleted {} contracts before inserting {} new contracts", (Object)deletedContracts, (Object)messageContracts.size());
            this.removeDuplicateContracts(this.messageContractRepository.getContractsForAppVersionTransactionId(appName, appVersion, transactionId), messageContracts);
            this.messageSchemaService.loadSchemas(messageContracts);
            this.messageContractRepository.saveContracts(messageContracts);
        }
    }

    private void removeDuplicateContracts(List<MessageContract> contractsInDb, List<MessageContract> messageContracts) {
        if (!contractsInDb.isEmpty()) {
            for (MessageContract messageContract : messageContracts) {
                Optional<MessageContract> messageContractInDb = contractsInDb.stream().filter(mc -> mc.getAppName().equals(messageContract.getAppName()) && mc.getAppVersion().equals(messageContract.getAppVersion()) && mc.getMessageType().equals(messageContract.getMessageType()) && mc.getMessageTypeVersion().equals(messageContract.getMessageTypeVersion()) && mc.getRole().equals((Object)messageContract.getRole()) && mc.getTopic().equals(messageContract.getTopic())).findFirst();
                messageContractInDb.ifPresent(contract -> {
                    this.messageContractRepository.deleteContractById(contract.getId());
                    log.debug("Deleted duplicated contract with id {}", (Object)contract.getId());
                });
            }
        }
    }

    private void saveContracts(String appName, String appVersion, List<MessageContract> messageContracts) {
        int deletedContracts = this.messageContractRepository.deleteContractsForAppVersion(appName, appVersion);
        this.entityManager.flush();
        log.debug("Deleted {} contracts before inserting {} new contracts", (Object)deletedContracts, (Object)messageContracts.size());
        this.messageSchemaService.loadSchemas(messageContracts);
        this.messageContractRepository.saveContracts(messageContracts);
    }

    @Transactional
    public int deleteContract(String appName, String appVersion, String messageType, String messageTypeVersion, String topic, MessageContractRole role) {
        return this.messageContractRepository.deleteContract(appName, appVersion, messageType, messageTypeVersion, topic, role);
    }

    @Generated
    public MessageContractService(MessageContractRepository messageContractRepository, MessageSchemaService messageSchemaService, EntityManager entityManager) {
        this.messageContractRepository = messageContractRepository;
        this.messageSchemaService = messageSchemaService;
        this.entityManager = entityManager;
    }
}

