/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messagecontract.persistence.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import java.time.ZonedDateTime;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;

@Entity
public class Deployment {
    @Id
    private UUID id;
    @NonNull
    private String appName;
    @NonNull
    private String appVersion;
    @NonNull
    private String environment;
    private ZonedDateTime createdAt;

    private Deployment(String appName, String appVersion, String environment, ZonedDateTime overrideCreatedAt) {
        this.id = UUID.randomUUID();
        this.appName = appName;
        this.appVersion = appVersion;
        this.environment = environment;
        this.createdAt = overrideCreatedAt != null ? overrideCreatedAt : ZonedDateTime.now();
    }

    @Generated
    public static DeploymentBuilder builder() {
        return new DeploymentBuilder();
    }

    @Generated
    protected Deployment() {
    }

    @Generated
    public String toString() {
        return "Deployment(id=" + String.valueOf(this.getId()) + ", appName=" + this.getAppName() + ", appVersion=" + this.getAppVersion() + ", environment=" + this.getEnvironment() + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ")";
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @NonNull
    @Generated
    public String getAppName() {
        return this.appName;
    }

    @NonNull
    @Generated
    public String getAppVersion() {
        return this.appVersion;
    }

    @NonNull
    @Generated
    public String getEnvironment() {
        return this.environment;
    }

    @Generated
    public ZonedDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Deployment)) {
            return false;
        }
        Deployment other = (Deployment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Deployment;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public static class DeploymentBuilder {
        @Generated
        private String appName;
        @Generated
        private String appVersion;
        @Generated
        private String environment;
        @Generated
        private ZonedDateTime overrideCreatedAt;

        @Generated
        DeploymentBuilder() {
        }

        @Generated
        public DeploymentBuilder appName(String appName) {
            this.appName = appName;
            return this;
        }

        @Generated
        public DeploymentBuilder appVersion(String appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        @Generated
        public DeploymentBuilder environment(String environment) {
            this.environment = environment;
            return this;
        }

        @Generated
        public DeploymentBuilder overrideCreatedAt(ZonedDateTime overrideCreatedAt) {
            this.overrideCreatedAt = overrideCreatedAt;
            return this;
        }

        @Generated
        public Deployment build() {
            return new Deployment(this.appName, this.appVersion, this.environment, this.overrideCreatedAt);
        }

        @Generated
        public String toString() {
            return "Deployment.DeploymentBuilder(appName=" + this.appName + ", appVersion=" + this.appVersion + ", environment=" + this.environment + ", overrideCreatedAt=" + String.valueOf(this.overrideCreatedAt) + ")";
        }
    }
}

