/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messagecontract.persistence.model;

import ch.admin.bit.jeap.messagecontract.persistence.model.CompatibilityMode;
import ch.admin.bit.jeap.messagecontract.persistence.model.MessageContractRole;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Id;
import java.time.ZonedDateTime;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;

@Entity
public class MessageContract {
    @Id
    private UUID id;
    @NonNull
    private String appName;
    @NonNull
    private String appVersion;
    @NonNull
    private String messageType;
    @NonNull
    private String messageTypeVersion;
    @NonNull
    private String topic;
    @Enumerated(value=EnumType.STRING)
    @NonNull
    private MessageContractRole role;
    @NonNull
    private String registryUrl;
    private String commitHash;
    private String branch;
    @Enumerated(value=EnumType.STRING)
    @NonNull
    private CompatibilityMode compatibilityMode;
    private String avroProtocolSchema;
    private ZonedDateTime createdAt;
    private boolean deleted;
    private ZonedDateTime deletedAt;
    private String encryptionKeyId;
    private String transactionId;

    private MessageContract(String appName, String appVersion, String messageType, String messageTypeVersion, String topic, MessageContractRole role, String registryUrl, String commitHash, String branch, String avroProtocolSchema, CompatibilityMode compatibilityMode, String encryptionKeyId, String transactionId) {
        this.id = UUID.randomUUID();
        this.appName = appName;
        this.appVersion = appVersion;
        this.messageType = messageType;
        this.messageTypeVersion = messageTypeVersion;
        this.topic = topic;
        this.role = role;
        this.registryUrl = registryUrl;
        this.commitHash = commitHash;
        this.branch = branch;
        this.avroProtocolSchema = avroProtocolSchema;
        this.compatibilityMode = compatibilityMode;
        this.createdAt = ZonedDateTime.now();
        this.deleted = false;
        this.deletedAt = null;
        this.encryptionKeyId = encryptionKeyId;
        this.transactionId = transactionId;
    }

    public boolean referencesSpecificCommit() {
        return this.commitHash != null;
    }

    @Generated
    public static MessageContractBuilder builder() {
        return new MessageContractBuilder();
    }

    @Generated
    protected MessageContract() {
    }

    @Generated
    public String toString() {
        return "MessageContract(id=" + String.valueOf(this.getId()) + ", appName=" + this.getAppName() + ", appVersion=" + this.getAppVersion() + ", messageType=" + this.getMessageType() + ", messageTypeVersion=" + this.getMessageTypeVersion() + ", topic=" + this.getTopic() + ", role=" + String.valueOf((Object)this.getRole()) + ", registryUrl=" + this.getRegistryUrl() + ", commitHash=" + this.getCommitHash() + ", branch=" + this.getBranch() + ", compatibilityMode=" + String.valueOf((Object)this.getCompatibilityMode()) + ", avroProtocolSchema=" + this.getAvroProtocolSchema() + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", deleted=" + this.isDeleted() + ", deletedAt=" + String.valueOf(this.getDeletedAt()) + ", encryptionKeyId=" + this.getEncryptionKeyId() + ", transactionId=" + this.getTransactionId() + ")";
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @NonNull
    @Generated
    public String getAppName() {
        return this.appName;
    }

    @NonNull
    @Generated
    public String getAppVersion() {
        return this.appVersion;
    }

    @NonNull
    @Generated
    public String getMessageType() {
        return this.messageType;
    }

    @NonNull
    @Generated
    public String getMessageTypeVersion() {
        return this.messageTypeVersion;
    }

    @NonNull
    @Generated
    public String getTopic() {
        return this.topic;
    }

    @NonNull
    @Generated
    public MessageContractRole getRole() {
        return this.role;
    }

    @NonNull
    @Generated
    public String getRegistryUrl() {
        return this.registryUrl;
    }

    @Generated
    public String getCommitHash() {
        return this.commitHash;
    }

    @Generated
    public String getBranch() {
        return this.branch;
    }

    @NonNull
    @Generated
    public CompatibilityMode getCompatibilityMode() {
        return this.compatibilityMode;
    }

    @Generated
    public String getAvroProtocolSchema() {
        return this.avroProtocolSchema;
    }

    @Generated
    public ZonedDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public boolean isDeleted() {
        return this.deleted;
    }

    @Generated
    public ZonedDateTime getDeletedAt() {
        return this.deletedAt;
    }

    @Generated
    public String getEncryptionKeyId() {
        return this.encryptionKeyId;
    }

    @Generated
    public String getTransactionId() {
        return this.transactionId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageContract)) {
            return false;
        }
        MessageContract other = (MessageContract)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MessageContract;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public void setAvroProtocolSchema(String avroProtocolSchema) {
        this.avroProtocolSchema = avroProtocolSchema;
    }

    @Generated
    public static class MessageContractBuilder {
        @Generated
        private String appName;
        @Generated
        private String appVersion;
        @Generated
        private String messageType;
        @Generated
        private String messageTypeVersion;
        @Generated
        private String topic;
        @Generated
        private MessageContractRole role;
        @Generated
        private String registryUrl;
        @Generated
        private String commitHash;
        @Generated
        private String branch;
        @Generated
        private String avroProtocolSchema;
        @Generated
        private CompatibilityMode compatibilityMode;
        @Generated
        private String encryptionKeyId;
        @Generated
        private String transactionId;

        @Generated
        MessageContractBuilder() {
        }

        @Generated
        public MessageContractBuilder appName(String appName) {
            this.appName = appName;
            return this;
        }

        @Generated
        public MessageContractBuilder appVersion(String appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        @Generated
        public MessageContractBuilder messageType(String messageType) {
            this.messageType = messageType;
            return this;
        }

        @Generated
        public MessageContractBuilder messageTypeVersion(String messageTypeVersion) {
            this.messageTypeVersion = messageTypeVersion;
            return this;
        }

        @Generated
        public MessageContractBuilder topic(String topic) {
            this.topic = topic;
            return this;
        }

        @Generated
        public MessageContractBuilder role(MessageContractRole role) {
            this.role = role;
            return this;
        }

        @Generated
        public MessageContractBuilder registryUrl(String registryUrl) {
            this.registryUrl = registryUrl;
            return this;
        }

        @Generated
        public MessageContractBuilder commitHash(String commitHash) {
            this.commitHash = commitHash;
            return this;
        }

        @Generated
        public MessageContractBuilder branch(String branch) {
            this.branch = branch;
            return this;
        }

        @Generated
        public MessageContractBuilder avroProtocolSchema(String avroProtocolSchema) {
            this.avroProtocolSchema = avroProtocolSchema;
            return this;
        }

        @Generated
        public MessageContractBuilder compatibilityMode(CompatibilityMode compatibilityMode) {
            this.compatibilityMode = compatibilityMode;
            return this;
        }

        @Generated
        public MessageContractBuilder encryptionKeyId(String encryptionKeyId) {
            this.encryptionKeyId = encryptionKeyId;
            return this;
        }

        @Generated
        public MessageContractBuilder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        @Generated
        public MessageContract build() {
            return new MessageContract(this.appName, this.appVersion, this.messageType, this.messageTypeVersion, this.topic, this.role, this.registryUrl, this.commitHash, this.branch, this.avroProtocolSchema, this.compatibilityMode, this.encryptionKeyId, this.transactionId);
        }

        @Generated
        public String toString() {
            return "MessageContract.MessageContractBuilder(appName=" + this.appName + ", appVersion=" + this.appVersion + ", messageType=" + this.messageType + ", messageTypeVersion=" + this.messageTypeVersion + ", topic=" + this.topic + ", role=" + String.valueOf((Object)this.role) + ", registryUrl=" + this.registryUrl + ", commitHash=" + this.commitHash + ", branch=" + this.branch + ", avroProtocolSchema=" + this.avroProtocolSchema + ", compatibilityMode=" + String.valueOf((Object)this.compatibilityMode) + ", encryptionKeyId=" + this.encryptionKeyId + ", transactionId=" + this.transactionId + ")";
        }
    }
}

