/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messagecontract.persistence;

import ch.admin.bit.jeap.messagecontract.persistence.MessageContractInfo;
import ch.admin.bit.jeap.messagecontract.persistence.model.MessageContract;
import ch.admin.bit.jeap.messagecontract.persistence.model.MessageContractRole;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface JpaMessageContractRepository
extends CrudRepository<MessageContract, UUID> {
    public List<MessageContractInfo> findByDeletedFalse();

    @Modifying
    @Query(value="update MessageContract set deleted=true, deletedAt=:deletedAt where appName=:appName and appVersion=:appVersion and messageType=:messageType and messageTypeVersion=:messageTypeVersion and topic=:topic and role=:role")
    public int deleteContract(@Param(value="deletedAt") ZonedDateTime var1, @Param(value="appName") String var2, @Param(value="appVersion") String var3, @Param(value="messageType") String var4, @Param(value="messageTypeVersion") String var5, @Param(value="topic") String var6, @Param(value="role") MessageContractRole var7);

    @Modifying(flushAutomatically=true)
    @Query(value="delete MessageContract where id=:id")
    public void deleteContractById(@Param(value="id") UUID var1);

    @Modifying(flushAutomatically=true)
    @Query(value="delete MessageContract where appName=:appName and appVersion=:appVersion")
    public int deleteByAppNameAndAppVersion(@Param(value="appName") String var1, @Param(value="appVersion") String var2);

    @Modifying(flushAutomatically=true)
    @Query(value="delete MessageContract where appName=:appName and appVersion=:appVersion and (transactionId is null or transactionId<>:transactionId)")
    public int deleteByAppNameAndAppVersionNotSameTransactionId(@Param(value="appName") String var1, @Param(value="appVersion") String var2, @Param(value="transactionId") String var3);

    public boolean existsByAppNameAndAppVersionAndDeletedFalse(String var1, String var2);

    public List<MessageContract> findAllByAppNameAndAppVersionAndDeletedFalse(String var1, String var2);

    public List<MessageContract> findAllByAppNameAndAppVersionAndTransactionIdAndDeletedFalse(String var1, String var2, String var3);

    @Query(value="select distinct appName from MessageContract where topic = :topic and messageType = :messageType and role = :role and deleted = false")
    public Set<String> distinctAppNameByRoleForMessageTypeOnTopic(@Param(value="messageType") String var1, @Param(value="topic") String var2, @Param(value="role") MessageContractRole var3);

    public List<MessageContract> findAllByAppNameAndAppVersionAndMessageTypeAndTopicAndRoleAndDeletedFalse(String var1, String var2, String var3, String var4, MessageContractRole var5);

    @Query(value="SELECT DISTINCT mc.app_name AS appName, mc.app_version AS appVersion,\n                mc.message_type AS messageType, mc.message_type_version AS messageTypeVersion,\n                mc.topic, mc.role,\n                mc.registry_url AS registryUrl, mc.commit_hash AS commitHash, mc.branch,\n                mc.compatibility_mode AS compatibilityMode,\n                mc.encryption_key_id AS encryptionKeyId\nFROM message_contract mc\n    INNER JOIN (\n        SELECT DISTINCT ON (d.app_name) d.app_name, d.app_version, d.created_at\n        FROM deployment d\n        WHERE d.environment = :environment\n        ORDER BY d.app_name, d.created_at DESC\n    ) as latest_deployment\n    ON latest_deployment.app_name = mc.app_name AND latest_deployment.app_version = mc.app_version\nWHERE mc.deleted = false;\n", nativeQuery=true)
    public List<MessageContractInfo> findAllByEnvironment(@Param(value="environment") String var1);

    public List<MessageContractInfo> findAllByDeletedFalse();
}

