/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messagecontract.persistence;

import ch.admin.bit.jeap.messagecontract.persistence.JpaMessageContractRepository;
import ch.admin.bit.jeap.messagecontract.persistence.MessageContractInfo;
import ch.admin.bit.jeap.messagecontract.persistence.model.MessageContract;
import ch.admin.bit.jeap.messagecontract.persistence.model.MessageContractRole;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class MessageContractRepository {
    private final JpaMessageContractRepository jpaRepository;

    public void saveContracts(List<MessageContract> messageContracts) {
        this.jpaRepository.saveAll(messageContracts);
    }

    public void deleteContractById(UUID messageContractId) {
        this.jpaRepository.deleteContractById(messageContractId);
    }

    public int deleteContract(String appName, String appVersion, String messageType, String messageTypeVersion, String topic, MessageContractRole role) {
        return this.jpaRepository.deleteContract(ZonedDateTime.now(), appName, appVersion, messageType, messageTypeVersion, topic, role);
    }

    public int deleteContractsForAppVersion(String appName, String appVersion) {
        return this.jpaRepository.deleteByAppNameAndAppVersion(appName, appVersion);
    }

    public int deleteByAppNameAndAppVersionNotSameTransactionId(String appName, String appVersion, String transactionId) {
        return this.jpaRepository.deleteByAppNameAndAppVersionNotSameTransactionId(appName, appVersion, transactionId);
    }

    public boolean existsByAppNameAndAppVersion(String appName, String appVersion) {
        return this.jpaRepository.existsByAppNameAndAppVersionAndDeletedFalse(appName, appVersion);
    }

    public List<MessageContract> getContractsForAppVersionTransactionId(String appName, String appVersion, String transactionId) {
        return this.jpaRepository.findAllByAppNameAndAppVersionAndTransactionIdAndDeletedFalse(appName, appVersion, transactionId);
    }

    public List<MessageContract> getContractsForAppVersion(String appName, String appVersion) {
        return this.jpaRepository.findAllByAppNameAndAppVersionAndDeletedFalse(appName, appVersion);
    }

    public Set<String> distinctAppNameByRoleForMessageTypeOnTopic(String messageTypeName, String topic, MessageContractRole role) {
        return this.jpaRepository.distinctAppNameByRoleForMessageTypeOnTopic(messageTypeName, topic, role);
    }

    public List<MessageContract> getContractsForAppVersionAndMessageTypeOnTopicWithRole(String appName, String appVersion, String messageType, String topic, MessageContractRole role) {
        return this.jpaRepository.findAllByAppNameAndAppVersionAndMessageTypeAndTopicAndRoleAndDeletedFalse(appName, appVersion, messageType, topic, role);
    }

    public List<MessageContractInfo> findMessageContractInfosByEnvironment(String environment) {
        return this.jpaRepository.findAllByEnvironment(environment);
    }

    public List<MessageContractInfo> findAllMessageContractInfos() {
        return this.jpaRepository.findAllByDeletedFalse();
    }

    @Generated
    public MessageContractRepository(JpaMessageContractRepository jpaRepository) {
        this.jpaRepository = jpaRepository;
    }
}

