/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messagecontract.persistence;

import ch.admin.bit.jeap.messagecontract.persistence.model.Deployment;
import java.util.List;
import java.util.UUID;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface JpaDeploymentRepository
extends JpaRepository<Deployment, UUID> {
    public List<Deployment> findTop10ByOrderByCreatedAtDesc();

    @Query(value="select d.appVersion from Deployment d where d.appName = :appName and d.environment = :environment order by d.createdAt desc")
    public List<String> findAppVersionCurrentlyDeployedOnEnvironment(@Param(value="appName") String var1, @Param(value="environment") String var2, Pageable var3);

    @Query(value="SELECT DISTINCT ON (app_name, environment)\nid, app_name, app_version, environment, created_at\nFROM deployment\nORDER BY app_name, environment, created_at DESC\n", nativeQuery=true)
    public List<Deployment> findNewestDeploymentPerAppAndEnv();

    public void deleteByAppNameAndEnvironment(String var1, String var2);
}

