/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messagecontract.test;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.revwalk.RevCommit;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public record TestRegistryRepo(Path repoDir, String revision, String url) {
    public static final String EVENT_DIR = "descriptor/activ/event/activzoneenteredevent";
    private static final String SYSTEM_COMMON_DIR = "descriptor/activ/_common";
    private static final String ROOT_COMMON_DIR = "descriptor/_common";

    public static TestRegistryRepo createMessageTypeRegistryRepository() throws Exception {
        TestRegistryRepo testRegistryRepo;
        block8: {
            Path repoDir = Files.createTempDirectory("test-repo", new FileAttribute[0]);
            Git newRepo = TestRegistryRepo.initGitRepo(repoDir);
            try {
                TestRegistryRepo.copyTestRegistryFilesToRepositoryDir(repoDir);
                RevCommit commit = TestRegistryRepo.addAndCommitTestFiles(newRepo);
                testRegistryRepo = new TestRegistryRepo(repoDir, commit.getId().name(), repoDir.toUri().toString());
                if (newRepo == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (newRepo != null) {
                        try {
                            newRepo.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    FileUtils.forceDelete((File)repoDir.toFile());
                    throw ex;
                }
            }
            newRepo.close();
        }
        return testRegistryRepo;
    }

    private static Git initGitRepo(Path repoDir) throws GitAPIException {
        return Git.init().setDirectory(repoDir.toFile()).setGitDir(repoDir.resolve(".git").toFile()).setInitialBranch("master").call();
    }

    private static RevCommit addAndCommitTestFiles(Git newRepo) throws GitAPIException {
        newRepo.add().addFilepattern(".").call();
        return newRepo.commit().setAuthor("test", "test@mail.com").setMessage("initial revision").call();
    }

    private static void copyTestRegistryFilesToRepositoryDir(Path repoDir) throws IOException {
        Resource[] resources;
        File rootDirectory = repoDir.toFile();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        for (Resource resource : resources = resolver.getResources("classpath*:/test-registry/**")) {
            if (!resource.exists() || !resource.isReadable() || resource.contentLength() <= 0L) continue;
            URL url = resource.getURL();
            String urlString = url.toExternalForm();
            String targetName = urlString.substring(urlString.indexOf("descriptor/"));
            File destination = new File(rootDirectory, targetName);
            FileUtils.copyURLToFile((URL)url, (File)destination);
        }
    }

    public void addAndCommitFile(Path file, String content) throws Exception {
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        Files.writeString(file, (CharSequence)content, new OpenOption[0]);
        try (Git git = Git.open((File)this.repoDir.toFile());){
            git.add().addFilepattern(".").call();
            git.commit().setAuthor("test", "test@mail.com").setMessage("add file").call();
        }
    }

    public void delete() throws IOException {
        FileUtils.forceDelete((File)this.repoDir.toFile());
    }
}

