/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messagecontract.web.config;

import ch.admin.bit.jeap.messagecontract.web.config.WebSecurityProperties;
import java.util.ArrayList;
import lombok.Generated;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.provisioning.InMemoryUserDetailsManager;
import org.springframework.security.web.SecurityFilterChain;

@Configuration
@EnableMethodSecurity
class WebSecurityConfig {
    private static final String WRITE_ROLE = "messagecontract-write";
    private static final String UPLOAD_CONTRACT_ROLE = "messagecontract-contract-upload";
    private final WebSecurityProperties webSecurityProperties;

    @Bean
    SecurityFilterChain apiSecurityFilterChain(HttpSecurity http) throws Exception {
        http.securityMatcher(new String[]{"/api/**", "/error"}).csrf(AbstractHttpConfigurer::disable).sessionManagement(management -> management.sessionCreationPolicy(SessionCreationPolicy.STATELESS)).httpBasic(Customizer.withDefaults()).authorizeHttpRequests(requests -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)requests.requestMatchers(new String[]{"/error"})).permitAll().requestMatchers(HttpMethod.GET, new String[]{"/api/contracts"})).permitAll().requestMatchers(HttpMethod.GET, new String[]{"/api/deployments"})).permitAll().anyRequest()).hasAnyRole(new String[]{WRITE_ROLE, UPLOAD_CONTRACT_ROLE}));
        return (SecurityFilterChain)http.build();
    }

    @Bean
    public InMemoryUserDetailsManager userDetailsService() {
        ArrayList<UserDetails> users = new ArrayList<UserDetails>();
        if (this.webSecurityProperties.getWriteUsers() != null) {
            users.addAll(this.webSecurityProperties.getWriteUsers().stream().map(user -> User.withUsername((String)user.getUsername()).password(user.getPassword()).roles(new String[]{WRITE_ROLE}).build()).toList());
        }
        if (this.webSecurityProperties.getUploadContractUsers() != null) {
            users.addAll(this.webSecurityProperties.getUploadContractUsers().stream().map(user -> User.withUsername((String)user.getUsername()).password(user.getPassword()).roles(new String[]{UPLOAD_CONTRACT_ROLE}).build()).toList());
        }
        return new InMemoryUserDetailsManager(users);
    }

    @Generated
    public WebSecurityConfig(WebSecurityProperties webSecurityProperties) {
        this.webSecurityProperties = webSecurityProperties;
    }
}

