/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messagecontract.web.api;

import ch.admin.bit.jeap.messagecontract.domain.DeploymentService;
import ch.admin.bit.jeap.messagecontract.domain.compatibility.CompatibilityCheckResult;
import ch.admin.bit.jeap.messagecontract.domain.compatibility.CompatibilityService;
import ch.admin.bit.jeap.messagecontract.persistence.model.Deployment;
import ch.admin.bit.jeap.messagecontract.web.api.dto.DeploymentDto;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.validation.constraints.NotBlank;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/deployments"})
@Validated
public class DeploymentController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeploymentController.class);
    private final DeploymentService deploymentService;
    private final CompatibilityService compatibilityService;

    @GetMapping(produces={"application/json"})
    @Operation(summary="List last 10 deployments")
    public List<DeploymentDto> findLast10Deployments() {
        return this.deploymentService.findLast10Deployments().stream().map(DeploymentDto::fromDomainObject).toList();
    }

    @PutMapping(path={"/{appName}/{appVersion}/{environment}"})
    @Operation(summary="Register deployment for an app version on a environment", responses={@ApiResponse(responseCode="201", description="Deployment successfully registered"), @ApiResponse(responseCode="200", description="Deployment ignored because appName and/or appVersion are unknown")})
    @PreAuthorize(value="hasAnyRole('messagecontract-write', 'messagecontract-contract-upload')")
    public ResponseEntity<String> registerNewDeployment(@NotBlank @PathVariable String appName, @NotBlank @PathVariable String appVersion, @NotBlank @PathVariable String environment) {
        log.info("Save new Deployment: app={}:{} environment={}", new Object[]{appName, appVersion, environment});
        Deployment deployment = this.deploymentService.saveNewDeployment(appName, appVersion, environment.toUpperCase());
        if (deployment != null) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)"Deployment successfully registered");
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)"Deployment ignored because appName and/or appVersion are unknown");
    }

    @DeleteMapping(path={"/{appName}/{environment}"})
    @Operation(summary="Deletes a deployment of an app on a environment", responses={@ApiResponse(responseCode="200", description="Deployment deleted")})
    @PreAuthorize(value="hasRole('messagecontract-write')")
    public ResponseEntity<String> deleteDeployment(@NotBlank @PathVariable(value="appName") String appName, @NotBlank @PathVariable(value="environment") String environment) {
        log.info("Deleting Deployment: app={} environment={}", (Object)appName, (Object)environment);
        this.deploymentService.deleteDeployment(appName, environment.toUpperCase());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)"Deployment successfully deleted");
    }

    @GetMapping(produces={"application/json"}, path={"/compatibility/{appName}/{appVersion}/{environment}"})
    @Operation(summary="Get compatibility of a planned deployment regarding the app's contracts with consumer/producer versions on the environment", responses={@ApiResponse(responseCode="200", description="App version is compatible with consumers/producers on environment"), @ApiResponse(responseCode="412", description="App version is not compatible with consumers/producers on environment, schema incompatibilities have been detected")})
    @PreAuthorize(value="hasAnyRole('messagecontract-read', 'messagecontract-write', 'messagecontract-contract-upload')")
    public ResponseEntity<CompatibilityCheckResult> getCompatibility(@NotBlank @PathVariable String appName, @NotBlank @PathVariable String appVersion, @NotBlank @PathVariable String environment) {
        CompatibilityCheckResult compatibilityCheckResult = this.compatibilityService.checkCompatibility(appName, appVersion, environment.toUpperCase());
        log.info("Compatibility check result for {}:{} on {}: {}", new Object[]{appName, appVersion, environment, compatibilityCheckResult.compatible()});
        if (compatibilityCheckResult.compatible()) {
            return ResponseEntity.ok((Object)compatibilityCheckResult);
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.PRECONDITION_FAILED).body((Object)compatibilityCheckResult);
    }

    @Generated
    public DeploymentController(DeploymentService deploymentService, CompatibilityService compatibilityService) {
        this.deploymentService = deploymentService;
        this.compatibilityService = compatibilityService;
    }
}

