/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messagecontract.web.api;

import ch.admin.bit.jeap.messagecontract.domain.MessageContractService;
import ch.admin.bit.jeap.messagecontract.web.api.dto.CreateMessageContractsDto;
import ch.admin.bit.jeap.messagecontract.web.api.dto.MessageContractDto;
import ch.admin.bit.jeap.messagecontract.web.api.dto.MessageContractRole;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.logstash.logback.argument.StructuredArguments;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/contracts"})
@Validated
public class ContractController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ContractController.class);
    private final MessageContractService messageContractService;

    @GetMapping(produces={"application/json"})
    @Operation(summary="List all contracts")
    public List<MessageContractDto> getContracts(@RequestParam(name="env", required=false) String environment) {
        ArrayList contracts = StringUtils.isBlank((CharSequence)environment) ? new ArrayList(this.messageContractService.getAllContracts()) : new ArrayList(this.messageContractService.getContractsForEnvironment(environment));
        return contracts.stream().map(MessageContractDto::fromDomainObject).toList();
    }

    @PutMapping(path={"/{appName}/{appVersion}"}, consumes={"application/json"})
    @Operation(summary="Upload contracts for an app version. Users with role messagecontract-contract-upload are allowed to upload contracts")
    @PreAuthorize(value="hasAnyRole('messagecontract-write', 'messagecontract-contract-upload')")
    @ResponseStatus(value=HttpStatus.CREATED)
    public void uploadContracts(@Valid @RequestBody CreateMessageContractsDto messageContractsDto, @NotBlank @PathVariable @Parameter(description="Name of the application") String appName, @NotBlank @PathVariable @Parameter(description="Version of the application") String appVersion, @RequestParam(required=false) @Parameter(description="Identifies the upload transaction uniquely") String transactionId) {
        log.info("Contracts uploaded: app={}:{} transactionId={} contracts={} from:{}", new Object[]{appName, appVersion, transactionId, messageContractsDto, StructuredArguments.kv((String)"user", (Object)SecurityContextHolder.getContext().getAuthentication().getName())});
        this.messageContractService.saveContracts(appName, appVersion, transactionId, messageContractsDto.toDomainObjects(appName, appVersion, transactionId));
    }

    @DeleteMapping(value={"/{appName}/{appVersion}"})
    @Operation(summary="Delete a contract")
    @PreAuthorize(value="hasRole('messagecontract-write')")
    public void deleteContract(@NotBlank @PathVariable String appName, @NotBlank @PathVariable String appVersion, @NotBlank @RequestParam String messageType, @NotBlank @RequestParam String messageTypeVersion, @NotBlank @RequestParam String topic, @NotNull @RequestParam MessageContractRole role) {
        int deleteContractCount = this.messageContractService.deleteContract(appName, appVersion, messageType, messageTypeVersion, topic, role.toDomainObject());
        log.info("Marked {} contract(s) as deleted: {} {} {} {} {} {}", new Object[]{deleteContractCount, appName, appVersion, messageType, messageTypeVersion, topic, role});
    }

    @Generated
    public ContractController(MessageContractService messageContractService) {
        this.messageContractService = messageContractService;
    }
}

