/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messageexchange.kafka;

import ch.admin.bit.jeap.messageexchange.domain.Message;
import ch.admin.bit.jeap.messageexchange.domain.malwarescan.PublishedScanStatus;
import ch.admin.bit.jeap.messageexchange.domain.messaging.EventPublisher;
import ch.admin.bit.jeap.messageexchange.event.message.received.B2BMessageReceivedEvent;
import ch.admin.bit.jeap.messageexchange.event.message.received.S3ObjectMalwareScanStatus;
import ch.admin.bit.jeap.messageexchange.event.message.sent.B2BMessageSentEvent;
import ch.admin.bit.jeap.messageexchange.kafka.B2BMessageReceivedEventBuilder;
import ch.admin.bit.jeap.messageexchange.kafka.B2BMessageSentEventBuilder;
import ch.admin.bit.jeap.messageexchange.kafka.TopicConfiguration;
import ch.admin.bit.jeap.messageexchange.plugin.api.listener.MessageReceivedListener;
import ch.admin.bit.jeap.messageexchange.plugin.api.listener.MessageResult;
import ch.admin.bit.jeap.messaging.avro.AvroMessage;
import ch.admin.bit.jeap.messaging.avro.AvroMessageKey;
import ch.admin.bit.jeap.messaging.kafka.properties.KafkaProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Component;

@Component
public class KafkaEventPublisher
implements EventPublisher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KafkaEventPublisher.class);
    private final KafkaTemplate<AvroMessageKey, AvroMessage> kafkaTemplate;
    private final TopicConfiguration topicConfiguration;
    private final KafkaProperties kafkaProperties;
    private final List<MessageReceivedListener> messageReceivedListeners;

    public void publishMessageReceivedEvent(UUID messageId, String bpId, String type, PublishedScanStatus externalPublishedScanStatus) {
        ArrayList<CompletableFuture> sendResults = new ArrayList<CompletableFuture>();
        S3ObjectMalwareScanStatus scanStatus = this.mapStatus(externalPublishedScanStatus);
        MessageResult b2BMessageReceivedEvent = this.getB2BMessageReceivedEvent(messageId, bpId, type, scanStatus);
        log.debug("Publishing event {} to topic {}.", (Object)b2BMessageReceivedEvent, (Object)b2BMessageReceivedEvent.topicName());
        sendResults.add(this.kafkaTemplate.send(b2BMessageReceivedEvent.topicName(), (Object)b2BMessageReceivedEvent.message()));
        log.debug("Publishing events from configured plugin-api: found {} listeners", (Object)this.messageReceivedListeners.size());
        for (MessageReceivedListener listener : this.messageReceivedListeners) {
            MessageResult messageResult = listener.onMessageReceived(messageId, bpId, type);
            log.debug("Publishing event {} to topic {}.", (Object)messageResult, (Object)messageResult.topicName());
            sendResults.add(this.kafkaTemplate.send(messageResult.topicName(), (Object)messageResult.message()));
        }
        CompletableFuture.allOf((CompletableFuture[])sendResults.toArray(CompletableFuture[]::new)).join();
    }

    public void publishMessageSentEvent(Message message) {
        B2BMessageSentEvent messageSentEvent = this.getB2BMessageSentEvent(message);
        String topicName = this.topicConfiguration.getMessageSent();
        log.debug("Publishing event {} to topic {}.", (Object)messageSentEvent, (Object)topicName);
        this.kafkaTemplate.send(topicName, (Object)messageSentEvent);
    }

    private MessageResult getB2BMessageReceivedEvent(UUID messageId, String bpId, String type, S3ObjectMalwareScanStatus scanStatus) {
        B2BMessageReceivedEvent messageReceivedEvent = ((B2BMessageReceivedEventBuilder)B2BMessageReceivedEventBuilder.create().bpId(bpId).messageId(messageId.toString()).type(type).scanStatus(scanStatus).systemName(this.kafkaProperties.getSystemName()).serviceName(this.kafkaProperties.getServiceName()).idempotenceId(messageId.toString())).build();
        return new MessageResult(this.topicConfiguration.getMessageReceived(), (AvroMessage)messageReceivedEvent);
    }

    private B2BMessageSentEvent getB2BMessageSentEvent(Message message) {
        return ((B2BMessageSentEventBuilder)B2BMessageSentEventBuilder.create().bpId(message.getBpId()).messageId(message.getMessageId().toString()).type(message.getMessageType()).topicName(message.getTopicName()).groupId(message.getGroupId()).partnerTopic(message.getPartnerTopic()).systemName(this.kafkaProperties.getSystemName()).serviceName(this.kafkaProperties.getServiceName()).idempotenceId(message.getMessageId().toString())).build();
    }

    private S3ObjectMalwareScanStatus mapStatus(PublishedScanStatus externalPublishedScanStatus) {
        return S3ObjectMalwareScanStatus.valueOf((String)externalPublishedScanStatus.name());
    }

    @Generated
    public KafkaEventPublisher(KafkaTemplate<AvroMessageKey, AvroMessage> kafkaTemplate, TopicConfiguration topicConfiguration, KafkaProperties kafkaProperties, List<MessageReceivedListener> messageReceivedListeners) {
        this.kafkaTemplate = kafkaTemplate;
        this.topicConfiguration = topicConfiguration;
        this.kafkaProperties = kafkaProperties;
        this.messageReceivedListeners = messageReceivedListeners;
    }
}

