/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messageexchange.kafka;

import ch.admin.bit.jeap.messageexchange.event.message.received.B2BMessageReceivedEvent;
import ch.admin.bit.jeap.messageexchange.event.message.sent.B2BMessageSentEvent;
import ch.admin.bit.jeap.messageexchange.kafka.TopicConfiguration;
import ch.admin.bit.jeap.messaging.avro.AvroMessageType;
import ch.admin.bit.jeap.messaging.kafka.contract.ContractsProvider;
import ch.admin.bit.jeap.messaging.kafka.contract.DefaultContractsValidator;
import ch.admin.bit.jeap.messaging.model.MessageType;
import jakarta.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class MessageExchangeServiceContractsValidator {
    private static final AvroMessageType B2B_MESSAGE_RECEIVED_EVENT = AvroMessageType.newBuilder().setName(B2BMessageReceivedEvent.getClassSchema().getName()).setVersion("1.1.0").build();
    private static final AvroMessageType B2B_MESSAGE_SENT_EVENT = AvroMessageType.newBuilder().setName(B2BMessageSentEvent.getClassSchema().getName()).setVersion("1.0.0").build();
    private final DefaultContractsValidator defaultContractsValidator;
    private final TopicConfiguration topicConfiguration;

    public MessageExchangeServiceContractsValidator(@Value(value="${spring.application.name}") String appName, ContractsProvider contractsProvider, TopicConfiguration topicConfiguration) {
        this.defaultContractsValidator = new DefaultContractsValidator(appName, contractsProvider);
        this.topicConfiguration = topicConfiguration;
    }

    @PostConstruct
    public void checkContracts() {
        this.defaultContractsValidator.ensurePublisherContract((MessageType)B2B_MESSAGE_RECEIVED_EVENT, this.topicConfiguration.getMessageReceived());
        if (this.topicConfiguration.getMessageSent() != null) {
            this.defaultContractsValidator.ensurePublisherContract((MessageType)B2B_MESSAGE_SENT_EVENT, this.topicConfiguration.getMessageSent());
        }
    }
}

