/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messageexchange.kafka;

import ch.admin.bit.jeap.messageexchange.domain.sent.MessageSentProperties;
import jakarta.annotation.PostConstruct;
import jakarta.validation.constraints.NotEmpty;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import lombok.Generated;
import org.apache.kafka.clients.admin.AdminClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.kafka.core.KafkaAdmin;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;

@Configuration
@ConfigurationProperties(prefix="jeap.messageexchange.kafka.topic")
@Validated
public class TopicConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TopicConfiguration.class);
    @NotEmpty
    private String messageReceived;
    private String messageSent;

    @Generated
    public TopicConfiguration() {
    }

    @Generated
    public String getMessageReceived() {
        return this.messageReceived;
    }

    @Generated
    public String getMessageSent() {
        return this.messageSent;
    }

    @Generated
    public void setMessageReceived(String messageReceived) {
        this.messageReceived = messageReceived;
    }

    @Generated
    public void setMessageSent(String messageSent) {
        this.messageSent = messageSent;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TopicConfiguration)) {
            return false;
        }
        TopicConfiguration other = (TopicConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$messageReceived = this.getMessageReceived();
        String other$messageReceived = other.getMessageReceived();
        if (this$messageReceived == null ? other$messageReceived != null : !this$messageReceived.equals(other$messageReceived)) {
            return false;
        }
        String this$messageSent = this.getMessageSent();
        String other$messageSent = other.getMessageSent();
        return !(this$messageSent == null ? other$messageSent != null : !this$messageSent.equals(other$messageSent));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TopicConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $messageReceived = this.getMessageReceived();
        result = result * 59 + ($messageReceived == null ? 43 : $messageReceived.hashCode());
        String $messageSent = this.getMessageSent();
        result = result * 59 + ($messageSent == null ? 43 : $messageSent.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TopicConfiguration(messageReceived=" + this.getMessageReceived() + ", messageSent=" + this.getMessageSent() + ")";
    }

    @Configuration
    @Profile(value={"cloud|aws"})
    static class TopicConfigurationCloud {
        private final KafkaAdmin kafkaAdmin;
        private final MessageSentProperties messageSentProperties;
        private final TopicConfiguration topicConfiguration;

        @PostConstruct
        public void checkIfTopicsExist() throws ExecutionException, InterruptedException {
            try (AdminClient adminClient = AdminClient.create((Map)this.kafkaAdmin.getConfigurationProperties());){
                this.doCheckIfTopicExists(adminClient);
            }
        }

        void doCheckIfTopicExists(AdminClient adminClient) throws InterruptedException, ExecutionException {
            ArrayList<String> topics = new ArrayList<String>();
            topics.add(this.topicConfiguration.getMessageReceived());
            if (this.messageSentProperties.isEnabled()) {
                if (!StringUtils.hasText((String)this.topicConfiguration.getMessageSent())) {
                    throw new IllegalStateException("Message sent enabled but no topic is configured");
                }
                topics.add(this.topicConfiguration.getMessageSent());
            }
            log.info("Checking if topics exist: {}", topics);
            Map stringTopicDescriptionMap = (Map)adminClient.describeTopics(topics).allTopicNames().get();
            stringTopicDescriptionMap.forEach((name, desc) -> log.info("{}: {}", name, desc));
            log.info("All topics exist, good to go");
        }

        @Generated
        public TopicConfigurationCloud(KafkaAdmin kafkaAdmin, MessageSentProperties messageSentProperties, TopicConfiguration topicConfiguration) {
            this.kafkaAdmin = kafkaAdmin;
            this.messageSentProperties = messageSentProperties;
            this.topicConfiguration = topicConfiguration;
        }
    }
}

