/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messageexchange.domain;

import java.math.BigInteger;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;

public class Message {
    private BigInteger sequenceId;
    private UUID messageId;
    private String topicName;
    private String bpId;
    private String groupId;
    private String messageType;
    private LocalDateTime datePublished;
    private String partnerTopic;

    private Message(@NonNull String bpId, String groupId, @NonNull UUID messageId, @NonNull String messageType, LocalDateTime overrideCreatedAt, String partnerTopic, @NonNull String topicName) {
        if (bpId == null) {
            throw new NullPointerException("bpId is marked non-null but is null");
        }
        if (messageId == null) {
            throw new NullPointerException("messageId is marked non-null but is null");
        }
        if (messageType == null) {
            throw new NullPointerException("messageType is marked non-null but is null");
        }
        if (topicName == null) {
            throw new NullPointerException("topicName is marked non-null but is null");
        }
        this.bpId = bpId;
        this.datePublished = Objects.requireNonNullElseGet(overrideCreatedAt, LocalDateTime::now);
        this.groupId = groupId;
        this.messageId = messageId;
        this.messageType = messageType;
        this.partnerTopic = partnerTopic;
        this.topicName = topicName;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Message{");
        sb.append("messageId=").append(this.messageId);
        if (this.sequenceId != null) {
            sb.append(",sequenceId=").append(this.sequenceId);
        }
        sb.append(", topicName='").append(this.topicName).append('\'');
        sb.append(", bpId='").append(this.bpId).append('\'');
        sb.append(", groupId='").append(this.groupId).append('\'');
        sb.append(", messageType='").append(this.messageType).append('\'');
        sb.append(", datePublished=").append(this.datePublished);
        sb.append(", partnerTopic='").append(this.partnerTopic).append('\'');
        sb.append('}');
        return sb.toString();
    }

    @Generated
    public static MessageBuilder builder() {
        return new MessageBuilder();
    }

    @Generated
    public Message(BigInteger sequenceId, UUID messageId, String topicName, String bpId, String groupId, String messageType, LocalDateTime datePublished, String partnerTopic) {
        this.sequenceId = sequenceId;
        this.messageId = messageId;
        this.topicName = topicName;
        this.bpId = bpId;
        this.groupId = groupId;
        this.messageType = messageType;
        this.datePublished = datePublished;
        this.partnerTopic = partnerTopic;
    }

    @Generated
    public BigInteger getSequenceId() {
        return this.sequenceId;
    }

    @Generated
    public UUID getMessageId() {
        return this.messageId;
    }

    @Generated
    public String getTopicName() {
        return this.topicName;
    }

    @Generated
    public String getBpId() {
        return this.bpId;
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public String getMessageType() {
        return this.messageType;
    }

    @Generated
    public LocalDateTime getDatePublished() {
        return this.datePublished;
    }

    @Generated
    public String getPartnerTopic() {
        return this.partnerTopic;
    }

    @Generated
    public static class MessageBuilder {
        @Generated
        private String bpId;
        @Generated
        private String groupId;
        @Generated
        private UUID messageId;
        @Generated
        private String messageType;
        @Generated
        private LocalDateTime overrideCreatedAt;
        @Generated
        private String partnerTopic;
        @Generated
        private String topicName;

        @Generated
        MessageBuilder() {
        }

        @Generated
        public MessageBuilder bpId(@NonNull String bpId) {
            if (bpId == null) {
                throw new NullPointerException("bpId is marked non-null but is null");
            }
            this.bpId = bpId;
            return this;
        }

        @Generated
        public MessageBuilder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        @Generated
        public MessageBuilder messageId(@NonNull UUID messageId) {
            if (messageId == null) {
                throw new NullPointerException("messageId is marked non-null but is null");
            }
            this.messageId = messageId;
            return this;
        }

        @Generated
        public MessageBuilder messageType(@NonNull String messageType) {
            if (messageType == null) {
                throw new NullPointerException("messageType is marked non-null but is null");
            }
            this.messageType = messageType;
            return this;
        }

        @Generated
        public MessageBuilder overrideCreatedAt(LocalDateTime overrideCreatedAt) {
            this.overrideCreatedAt = overrideCreatedAt;
            return this;
        }

        @Generated
        public MessageBuilder partnerTopic(String partnerTopic) {
            this.partnerTopic = partnerTopic;
            return this;
        }

        @Generated
        public MessageBuilder topicName(@NonNull String topicName) {
            if (topicName == null) {
                throw new NullPointerException("topicName is marked non-null but is null");
            }
            this.topicName = topicName;
            return this;
        }

        @Generated
        public Message build() {
            return new Message(this.bpId, this.groupId, this.messageId, this.messageType, this.overrideCreatedAt, this.partnerTopic, this.topicName);
        }

        @Generated
        public String toString() {
            return "Message.MessageBuilder(bpId=" + this.bpId + ", groupId=" + this.groupId + ", messageId=" + String.valueOf(this.messageId) + ", messageType=" + this.messageType + ", overrideCreatedAt=" + String.valueOf(this.overrideCreatedAt) + ", partnerTopic=" + this.partnerTopic + ", topicName=" + this.topicName + ")";
        }
    }
}

