/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messageexchange.domain.housekeeping;

import ch.admin.bit.jeap.messageexchange.domain.database.MessageRepository;
import ch.admin.bit.jeap.messageexchange.domain.housekeeping.HousekeepingProperties;
import io.micrometer.core.annotation.Timed;
import lombok.Generated;
import net.javacrumbs.shedlock.spring.annotation.SchedulerLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class HousekeepingService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HousekeepingService.class);
    private final MessageRepository messageRepository;
    private final HousekeepingProperties props;

    @Scheduled(cron="${jeap.messageexchange.housekeeping.cron:-}")
    @SchedulerLock(name="messageexchange-housekeeping", lockAtLeastFor="5s", lockAtMostFor="2h")
    @Timed(value="jeap_mes_housekeeping", description="Time taken to cleanup expired persistent messages")
    public void cleanupExpiredPersistentMessages() {
        if (!this.props.isEnabled()) {
            log.debug("Housekeeping is disabled");
            return;
        }
        log.info("Deleting expired messages with configuration {}", (Object)this.props);
        for (int i = 0; i < this.props.getMaxBatches(); ++i) {
            boolean deletedExpiredMessages = this.messageRepository.deleteExpiredMessages(this.props.getExpirationDays(), this.props.getBatchSize());
            if (!deletedExpiredMessages) {
                log.info("Deleted expired messages in {} batches", (Object)i);
                break;
            }
            if (i != this.props.getMaxBatches() - 1) continue;
            log.warn("Deleted expired messages in {} batches, but maxBatches was reached - not cleaning up any more batches", (Object)i);
        }
    }

    @Generated
    public HousekeepingService(MessageRepository messageRepository, HousekeepingProperties props) {
        this.messageRepository = messageRepository;
        this.props = props;
    }
}

