/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messageexchange.domain.objectstore;

import ch.admin.bit.jeap.messageexchange.domain.malwarescan.ScanStatus;
import ch.admin.bit.jeap.messageexchange.domain.objectstore.S3ObjectTags;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class S3ObjectTagsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(S3ObjectTagsService.class);
    private static final String TAG_KEY_BP_ID = "bpId";
    private static final String TAG_KEY_MESSAGE_TYPE = "messageType";
    private static final String TAG_KEY_SCAN_STATUS = "scanStatus";
    private static final String TAG_KEY_SAVE_TIME_IN_MILLIS = "saveTimeInMillis";

    public Map<String, String> toMap(String bpId, String messageType, ScanStatus scanStatus, long saveTimeInMillis) {
        return Map.of(TAG_KEY_BP_ID, bpId, TAG_KEY_MESSAGE_TYPE, messageType, TAG_KEY_SCAN_STATUS, scanStatus.name(), TAG_KEY_SAVE_TIME_IN_MILLIS, String.valueOf(saveTimeInMillis));
    }

    public Map<String, String> toMap(ScanStatus scanStatus) {
        return Map.of(TAG_KEY_SCAN_STATUS, scanStatus.name());
    }

    public S3ObjectTags getTagsfromMapAndValidate(String bucketName, String objectKey, Map<String, String> tags) {
        return this.getTagsfromMap(tags, (bpId, messageType, scanStatusString) -> {
            if (bpId == null || messageType == null || scanStatusString == null) {
                log.error("Won't publish message! Not all needed tags are present for S3 Object {}-{}, tags: {}", new Object[]{bucketName, objectKey, tags});
                throw new IllegalStateException("Not all needed tags are present for S3 Object " + bucketName + "-" + objectKey + ", tags: " + String.valueOf(tags));
            }
        });
    }

    public S3ObjectTags getTagsfromMap(Map<String, String> tags) {
        return this.getTagsfromMap(tags, ValidationHook.noOp());
    }

    private S3ObjectTags getTagsfromMap(Map<String, String> tags, ValidationHook validationHook) {
        String bpId = tags.getOrDefault(TAG_KEY_BP_ID, null);
        String messageType = tags.getOrDefault(TAG_KEY_MESSAGE_TYPE, null);
        String scanStatusString = tags.getOrDefault(TAG_KEY_SCAN_STATUS, null);
        String saveTimeInMillisString = tags.getOrDefault(TAG_KEY_SAVE_TIME_IN_MILLIS, null);
        validationHook.validate(bpId, messageType, scanStatusString);
        return new S3ObjectTags(bpId, messageType, scanStatusString == null ? null : ScanStatus.valueOf(scanStatusString), saveTimeInMillisString == null ? null : Long.valueOf(Long.parseLong(saveTimeInMillisString)));
    }

    private static interface ValidationHook {
        public void validate(String var1, String var2, String var3);

        public static ValidationHook noOp() {
            return (bpId, messageType, scanStatusString) -> {};
        }
    }
}

