/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messageexchange.domain.xml;

import ch.admin.bit.jeap.messageexchange.domain.MessageContent;
import ch.admin.bit.jeap.messageexchange.domain.xml.InvalidXMLInputException;
import com.fasterxml.aalto.AsyncByteArrayFeeder;
import com.fasterxml.aalto.AsyncXMLInputFactory;
import com.fasterxml.aalto.AsyncXMLStreamReader;
import com.fasterxml.aalto.stax.InputFactoryImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.input.TeeInputStream;

public class XmlValidatingOutputStream
extends OutputStream {
    private static final AsyncXMLInputFactory XML_INPUT_FACTORY = new InputFactoryImpl();
    private final AsyncXMLStreamReader<AsyncByteArrayFeeder> parser;
    private final int contentLength;
    private int bytesProcessed;
    private final String bpId;
    private final UUID messageId;
    private final byte[] singleByteBuffer;

    public static InputStream wrapInputStreamWithXmlValidation(UUID messageId, String bpId, MessageContent messageContent) {
        XmlValidatingOutputStream branch = new XmlValidatingOutputStream(messageContent.contentLength(), bpId, messageId);
        return new TeeInputStream(messageContent.inputStream(), (OutputStream)branch, true);
    }

    XmlValidatingOutputStream(int contentLength, String bpId, UUID messageId) {
        this.contentLength = contentLength == -1 ? Integer.MAX_VALUE : contentLength;
        this.bytesProcessed = 0;
        this.bpId = bpId;
        this.messageId = messageId;
        this.parser = XML_INPUT_FACTORY.createAsyncForByteArray();
        this.singleByteBuffer = new byte[1];
    }

    @Override
    public void close() throws IOException {
        ((AsyncByteArrayFeeder)this.parser.getInputFeeder()).endOfInput();
        try {
            this.parser.close();
        }
        catch (XMLStreamException e) {
            throw new IOException("Failed to close parser", e);
        }
    }

    @Override
    public void write(int data) throws IOException {
        this.singleByteBuffer[0] = (byte)data;
        this.write(this.singleByteBuffer);
    }

    @Override
    public void write(byte[] data) throws IOException {
        this.write(data, 0, data.length);
    }

    @Override
    public void write(byte[] data, int off, int len) throws IOException {
        try {
            ((AsyncByteArrayFeeder)this.parser.getInputFeeder()).feedInput(data, off, len);
            this.bytesProcessed += len;
            int tokenType = 0;
            while (this.parser.hasNext() && tokenType != 257) {
                tokenType = this.parser.next();
            }
            if (this.bytesProcessed >= this.contentLength) {
                ((AsyncByteArrayFeeder)this.parser.getInputFeeder()).endOfInput();
                if (tokenType == 257 && this.parser.hasNext()) {
                    tokenType = this.parser.next();
                }
                if (8 != tokenType) {
                    throw InvalidXMLInputException.incomplete(this.messageId, this.bpId);
                }
            }
        }
        catch (XMLStreamException e) {
            throw InvalidXMLInputException.invalid(this.messageId, this.bpId, e);
        }
    }
}

