/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messageexchange.domain.malwarescan;

import ch.admin.bit.jeap.messageexchange.domain.malwarescan.PublishedScanStatus;
import ch.admin.bit.jeap.messageexchange.domain.malwarescan.ScanResult;

public enum ScanStatus {
    NOT_SCANNED,
    SCAN_PENDING,
    NO_THREATS_FOUND,
    THREATS_FOUND,
    SCAN_FAILED;


    public static ScanStatus fromScanResult(ScanResult scanResult) {
        return switch (scanResult) {
            case ScanResult.NO_THREATS_FOUND -> NO_THREATS_FOUND;
            case ScanResult.THREATS_FOUND -> THREATS_FOUND;
            default -> SCAN_FAILED;
        };
    }

    public PublishedScanStatus toPublishedScanStatus() {
        return switch (this.ordinal()) {
            case 0 -> PublishedScanStatus.NOT_SCANNED;
            case 2 -> PublishedScanStatus.NO_THREATS_FOUND;
            case 3 -> PublishedScanStatus.THREATS_FOUND;
            default -> PublishedScanStatus.SCAN_FAILED;
        };
    }
}

