/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messageexchange.domain;

import ch.admin.bit.jeap.messageexchange.domain.Message;
import ch.admin.bit.jeap.messageexchange.domain.MessageContent;
import ch.admin.bit.jeap.messageexchange.domain.NextMessageResultDto;
import ch.admin.bit.jeap.messageexchange.domain.database.MessageRepository;
import ch.admin.bit.jeap.messageexchange.domain.dto.MessageSearchResultDto;
import ch.admin.bit.jeap.messageexchange.domain.exception.MalwareScanFailedOrBlockedException;
import ch.admin.bit.jeap.messageexchange.domain.malwarescan.MalwareScanProperties;
import ch.admin.bit.jeap.messageexchange.domain.malwarescan.PublishedScanStatus;
import ch.admin.bit.jeap.messageexchange.domain.malwarescan.S3ObjectMalwareScanResultInfo;
import ch.admin.bit.jeap.messageexchange.domain.malwarescan.ScanStatus;
import ch.admin.bit.jeap.messageexchange.domain.messaging.EventPublisher;
import ch.admin.bit.jeap.messageexchange.domain.metrics.MetricsService;
import ch.admin.bit.jeap.messageexchange.domain.objectstore.BucketType;
import ch.admin.bit.jeap.messageexchange.domain.objectstore.ObjectStore;
import ch.admin.bit.jeap.messageexchange.domain.objectstore.S3ObjectTags;
import ch.admin.bit.jeap.messageexchange.domain.objectstore.S3ObjectTagsService;
import ch.admin.bit.jeap.messageexchange.domain.sent.MessageSentProperties;
import ch.admin.bit.jeap.messageexchange.domain.xml.XmlValidatingOutputStream;
import ch.admin.bit.jeap.messageexchange.malware.api.MalwareScanTrigger;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MessageExchangeService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageExchangeService.class);
    private final ObjectStore objectStore;
    private final EventPublisher eventPublisher;
    private final MessageRepository messageRepository;
    private final MalwareScanProperties malwareScanProperties;
    private final MessageSentProperties messageSentProperties;
    private final MetricsService metricsService;
    private final S3ObjectTagsService tagsService;
    private final Optional<MalwareScanTrigger> malwareScanTriggerOptional;

    public Optional<MessageContent> getMessageFromInternalApplication(String bpId, UUID messageId) {
        String objectKey = MessageExchangeService.createInternalMessageObjectKey(bpId, messageId);
        log.trace("Retrieve payload for internal message with messageId {} from key {}", (Object)messageId, (Object)objectKey);
        return this.objectStore.loadMessage(BucketType.INTERNAL, objectKey);
    }

    public Optional<NextMessageResultDto> getNextMessageFromInternalApplication(UUID lastMessageId, String bpId, String partnerTopic, String topicName) {
        Optional<MessageContent> messageInfo;
        Optional<UUID> nextMessageId = this.messageRepository.getNextMessageId(lastMessageId, bpId, partnerTopic, topicName);
        if (nextMessageId.isPresent() && (messageInfo = this.getMessageFromInternalApplication(bpId, nextMessageId.get())).isPresent()) {
            log.trace("Found new message with messageId {} for bpId {} after lastMessageId {}", new Object[]{nextMessageId.get(), bpId, lastMessageId});
            return Optional.of(new NextMessageResultDto(nextMessageId.get(), messageInfo.get()));
        }
        log.trace("No new message found for bpId {} after lastMessageId {}", (Object)bpId, (Object)lastMessageId);
        return Optional.empty();
    }

    public Optional<MessageContent> getMessageFromPartner(UUID messageId) {
        log.trace("Retrieve payload for partner message with messageId {}", (Object)messageId);
        Optional<MessageContent> messageInfoWithTagsOptional = this.objectStore.loadMessageWithTags(BucketType.PARTNER, messageId.toString());
        if (messageInfoWithTagsOptional.isEmpty()) {
            return Optional.empty();
        }
        this.checkScanStatus(messageId, messageInfoWithTagsOptional.get());
        return messageInfoWithTagsOptional;
    }

    public void saveNewMessageFromPartner(UUID messageId, String bpId, String messageType, MessageContent rawMessageContent) throws IOException {
        try (InputStream inputStream = XmlValidatingOutputStream.wrapInputStreamWithXmlValidation(messageId, bpId, rawMessageContent);){
            ScanStatus scanStatus = this.malwareScanProperties.isEnabled() ? ScanStatus.SCAN_PENDING : ScanStatus.NOT_SCANNED;
            Map<String, String> tags = this.tagsService.toMap(bpId, messageType, scanStatus, System.currentTimeMillis());
            MessageContent messageContent = new MessageContent(inputStream, rawMessageContent.contentLength(), tags);
            this.objectStore.storeMessage(BucketType.PARTNER, messageId.toString(), messageContent);
            if (!this.malwareScanProperties.isEnabled()) {
                this.eventPublisher.publishMessageReceivedEvent(messageId, bpId, messageType, PublishedScanStatus.NOT_SCANNED);
            } else if (this.malwareScanTriggerOptional.isPresent()) {
                this.malwareScanTriggerOptional.get().triggerScan(messageId.toString(), this.objectStore.getBucketName(BucketType.PARTNER), messageContent.inputStream(), messageContent.contentLength());
            }
        }
    }

    public void saveNewMessageFromInternalApplication(Message message, MessageContent rawMessageContent) throws IOException {
        UUID messageId = message.getMessageId();
        String bpId = message.getBpId();
        try (InputStream inputStream = XmlValidatingOutputStream.wrapInputStreamWithXmlValidation(messageId, bpId, rawMessageContent);){
            MessageContent messageInfo = new MessageContent(inputStream, rawMessageContent.contentLength());
            this.objectStore.storeMessage(BucketType.INTERNAL, MessageExchangeService.createInternalMessageObjectKey(bpId, messageId), messageInfo);
            this.messageRepository.save(message);
            if (this.messageSentProperties.isEnabled()) {
                this.eventPublisher.publishMessageSentEvent(message);
            }
        }
    }

    public List<MessageSearchResultDto> getMessages(String bpId, String topicName, String groupId, UUID lastMessageId, String partnerTopic, int size) {
        return this.messageRepository.getMessages(bpId, topicName, groupId, lastMessageId, partnerTopic, size);
    }

    public void onMalwareScanResult(S3ObjectMalwareScanResultInfo scanResultInfo) {
        long messageArrivalTimeInMillis = System.currentTimeMillis();
        S3ObjectTags s3ObjectTags = this.updateAndGetValidatedTags(scanResultInfo);
        this.metricsService.publishMetrics(scanResultInfo.scanResult(), messageArrivalTimeInMillis, s3ObjectTags.saveTimeInMillis());
        this.publishMessageReceivedEvent(scanResultInfo.objectKey(), s3ObjectTags);
    }

    private void publishMessageReceivedEvent(String objectKey, S3ObjectTags actualTags) {
        UUID messageId = UUID.fromString(objectKey);
        ScanStatus scanStatus = actualTags.scanStatus();
        PublishedScanStatus externalPublishedScanStatus = scanStatus.toPublishedScanStatus();
        this.eventPublisher.publishMessageReceivedEvent(messageId, actualTags.bpId(), actualTags.messageType(), externalPublishedScanStatus);
    }

    private static String createInternalMessageObjectKey(String bpId, UUID messageId) {
        return bpId + "/" + String.valueOf(messageId);
    }

    private S3ObjectTags updateAndGetValidatedTags(S3ObjectMalwareScanResultInfo internalScanResult) {
        ScanStatus scanStatus = ScanStatus.fromScanResult(internalScanResult.scanResult());
        if (scanStatus == ScanStatus.SCAN_FAILED) {
            log.warn("Malware scan failed: {}", (Object)internalScanResult);
        }
        String bucketName = internalScanResult.bucketName();
        String objectKey = internalScanResult.objectKey();
        return this.updateAndGetValidatedTags(bucketName, objectKey, scanStatus);
    }

    private S3ObjectTags updateAndGetValidatedTags(String bucketName, String objectKey, ScanStatus scanStatus) {
        Map<String, String> tagsToUpdate = this.tagsService.toMap(scanStatus);
        Map<String, String> actualTags = this.objectStore.updateTagsAndGetTags(BucketType.PARTNER, bucketName, objectKey, tagsToUpdate);
        return this.tagsService.getTagsfromMapAndValidate(bucketName, objectKey, actualTags);
    }

    private void checkScanStatus(UUID messageId, MessageContent messageInfoWithTags) {
        S3ObjectTags s3ObjectTags = this.tagsService.getTagsfromMap(messageInfoWithTags.tags());
        ScanStatus scanStatus = s3ObjectTags.scanStatus();
        if (!this.doDeliverMessageWithStatus(scanStatus)) {
            log.error("Message {}-{} cannot be delivered because its malware scan status is {}", new Object[]{s3ObjectTags.bpId(), messageId, scanStatus});
            throw MalwareScanFailedOrBlockedException.malwareScanFailedOrBlockedException(messageId, scanStatus);
        }
    }

    private boolean doDeliverMessageWithStatus(ScanStatus scanStatus) {
        return scanStatus == null || scanStatus == ScanStatus.NOT_SCANNED || scanStatus == ScanStatus.NO_THREATS_FOUND;
    }

    @Generated
    public MessageExchangeService(ObjectStore objectStore, EventPublisher eventPublisher, MessageRepository messageRepository, MalwareScanProperties malwareScanProperties, MessageSentProperties messageSentProperties, MetricsService metricsService, S3ObjectTagsService tagsService, Optional<MalwareScanTrigger> malwareScanTriggerOptional) {
        this.objectStore = objectStore;
        this.eventPublisher = eventPublisher;
        this.messageRepository = messageRepository;
        this.malwareScanProperties = malwareScanProperties;
        this.messageSentProperties = messageSentProperties;
        this.metricsService = metricsService;
        this.tagsService = tagsService;
        this.malwareScanTriggerOptional = malwareScanTriggerOptional;
    }
}

