/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messageexchange.domain.malwarescan;

import ch.admin.bit.jeap.messageexchange.domain.MessageExchangeService;
import ch.admin.bit.jeap.messageexchange.domain.malwarescan.S3ObjectMalwareScanResultInfo;
import ch.admin.bit.jeap.messageexchange.malware.api.MalwareScanResult;
import ch.admin.bit.jeap.messageexchange.malware.api.MalwareScanResultListener;
import ch.admin.bit.jeap.messageexchange.malware.api.MalwareScanResultNotifier;
import jakarta.annotation.PostConstruct;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"jeap.messageexchange.malwarescan.enabled"}, havingValue="true")
public class S3ObjectMalwareScannedEventListener
implements MalwareScanResultListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(S3ObjectMalwareScannedEventListener.class);
    private final MessageExchangeService messageExchangeService;
    private final Optional<MalwareScanResultNotifier> notifier;

    @PostConstruct
    void init() {
        if (!this.notifier.isPresent()) {
            throw new IllegalStateException("MalwareScanResultNotifier bean is not available, even though malware scan is enabled");
        }
        this.notifier.get().subscribe((MalwareScanResultListener)this);
        log.info("MalwareScanResultNotifier bean is available, subscribed to malware scan results");
    }

    public void onMalwareScanResult(String key, String bucketName, MalwareScanResult scanResult) {
        S3ObjectMalwareScanResultInfo malwareScanResultInfo = new S3ObjectMalwareScanResultInfo(scanResult, bucketName, key);
        this.messageExchangeService.onMalwareScanResult(malwareScanResultInfo);
    }

    @Generated
    public S3ObjectMalwareScannedEventListener(MessageExchangeService messageExchangeService, Optional<MalwareScanResultNotifier> notifier) {
        this.messageExchangeService = messageExchangeService;
        this.notifier = notifier;
    }
}

