/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messageexchange.persistence;

import ch.admin.bit.jeap.db.tx.TransactionalReadReplica;
import ch.admin.bit.jeap.messageexchange.domain.Message;
import ch.admin.bit.jeap.messageexchange.domain.database.MessageRepository;
import ch.admin.bit.jeap.messageexchange.domain.dto.MessageSearchResultDto;
import io.micrometer.core.annotation.Timed;
import java.io.Serializable;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Repository
public class JdbcMessageRepository
implements MessageRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JdbcMessageRepository.class);
    private static final String INSERT_SQL = "INSERT INTO b2bhub_db_table(\"messageId\",\"bpId\",\"topicName\",\"groupId\",\"messageType\",\"datePublished\",\"partnerTopic\") VALUES (:messageId,:bpId,:topicName,:groupId,:messageType,:datePublished,:partnerTopic)";
    private static final String SELECT_BY_MESSAGE_ID = "SELECT * FROM b2bhub_db_table WHERE \"messageId\" = :messageId";
    private static final String SELECT_SEQUENCE_ID_OF_MESSAGE = "SELECT \"sequenceId\" FROM b2bhub_db_table WHERE \"bpId\" = :bpId AND \"messageId\" = :messageId";
    private static final String SELECT_NEXT_MESSAGE_ID_AFTER_SEQUENCE_ID = "    SELECT t.\"messageId\" FROM b2bhub_db_table t\n    WHERE t.\"bpId\" = :bpId\n      AND t.\"sequenceId\" > :sequenceId\n      %s\n      %s\n    ORDER BY t.\"sequenceId\" ASC\n    LIMIT 1\n";
    private static final String SELECT_NEXT_MESSAGES = "    SELECT t.\"messageId\", t.\"messageType\", t.\"groupId\", t.\"partnerTopic\" FROM b2bhub_db_table t\n    WHERE t.\"bpId\" = :bpId\n        %s\n        %s\n        %s\n        %s\n    ORDER BY t.\"sequenceId\"\n    LIMIT :size\n";
    private static final String DELETE_EXPIRED_MESSAGES = "WITH rows AS\n    (SELECT \"sequenceId\" FROM b2bhub_db_table\n        WHERE \"datePublished\" < NOW() - INTERVAL '%d DAYS'\n        LIMIT %d)\nDELETE FROM b2bhub_db_table\n    WHERE \"sequenceId\" IN (SELECT \"sequenceId\" FROM rows)\n";
    private static final String SEQUENCE_ID = "sequenceId";
    private static final String MESSAGE_TYPE = "messageType";
    private static final String PARTNER_TOPIC = "partnerTopic";
    private static final String DATE_PUBLISHED = "datePublished";
    private static final String GROUP_ID = "groupId";
    private static final String TOPIC_NAME = "topicName";
    private static final String BP_ID = "bpId";
    private static final String MESSAGE_ID = "messageId";
    private final NamedParameterJdbcTemplate jdbcTemplate;

    @Transactional
    @Timed(value="jeap_mes_repository_save", description="Time taken to save a message in the DB", percentiles={0.5, 0.8, 0.95, 0.99})
    public void save(Message message) {
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue(MESSAGE_ID, (Object)message.getMessageId().toString());
        params.addValue(BP_ID, (Object)message.getBpId());
        params.addValue(MESSAGE_TYPE, (Object)message.getMessageType());
        params.addValue(DATE_PUBLISHED, (Object)message.getDatePublished());
        params.addValue(PARTNER_TOPIC, (Object)message.getPartnerTopic());
        params.addValue(TOPIC_NAME, (Object)message.getTopicName());
        params.addValue(GROUP_ID, (Object)message.getGroupId());
        try {
            this.jdbcTemplate.update(INSERT_SQL, (SqlParameterSource)params);
        }
        catch (DuplicateKeyException e) {
            log.warn("Message with messageId {} already present in the database. Skipping...", (Object)message.getMessageId());
        }
    }

    @TransactionalReadReplica
    @Timed(value="jeap_mes_repository_find_by_message_id", description="Time taken to find a message in the DB", percentiles={0.5, 0.8, 0.95, 0.99})
    public Optional<Message> findByMessageId(UUID messageId) {
        Map<String, String> params = Map.of(MESSAGE_ID, messageId.toString());
        return this.jdbcTemplate.query(SELECT_BY_MESSAGE_ID, params, (rs, rowNum) -> new Message(rs.getObject(SEQUENCE_ID, BigInteger.class), UUID.fromString(rs.getString(MESSAGE_ID)), rs.getString(TOPIC_NAME), rs.getString(BP_ID), rs.getString(GROUP_ID), rs.getString(MESSAGE_TYPE), rs.getObject(DATE_PUBLISHED, LocalDateTime.class), rs.getString(PARTNER_TOPIC))).stream().findFirst();
    }

    @TransactionalReadReplica
    @Timed(value="jeap_mes_repository_get_messages", description="Time taken to get messages from the DB", percentiles={0.5, 0.8, 0.95, 0.99})
    public List<MessageSearchResultDto> getMessages(String bpId, String topicName, String groupId, UUID lastMessageId, String partnerTopic, int size) {
        Optional<Object> sequenceId = Optional.empty();
        if (lastMessageId != null) {
            sequenceId = this.getSequenceId(bpId, lastMessageId.toString());
        }
        HashMap<String, Integer> params = new HashMap<String, Integer>(Map.of(BP_ID, bpId, "size", size));
        String sequenceIdClause = "";
        String partnerTopicClause = "";
        String topicNameClause = "";
        String groupIdClause = "";
        if (sequenceId.isPresent()) {
            params.put(SEQUENCE_ID, (Integer)sequenceId.get());
            sequenceIdClause = "AND t.\"sequenceId\" > :sequenceId";
        }
        if (StringUtils.hasText((String)partnerTopic)) {
            params.put(PARTNER_TOPIC, (Integer)((Object)partnerTopic));
            partnerTopicClause = "AND t.\"partnerTopic\" = :partnerTopic";
        }
        if (StringUtils.hasText((String)topicName)) {
            params.put(TOPIC_NAME, (Integer)((Object)topicName));
            topicNameClause = "AND t.\"topicName\" = :topicName";
        }
        if (StringUtils.hasText((String)groupId)) {
            params.put(GROUP_ID, (Integer)((Object)groupId));
            groupIdClause = "AND t.\"groupId\" = :groupId";
        }
        return this.jdbcTemplate.query(SELECT_NEXT_MESSAGES.formatted(sequenceIdClause, partnerTopicClause, topicNameClause, groupIdClause), params, (rs, rowNum) -> new MessageSearchResultDto(UUID.fromString(rs.getString(MESSAGE_ID)), rs.getString(MESSAGE_TYPE), rs.getString(GROUP_ID), rs.getString(PARTNER_TOPIC)));
    }

    @TransactionalReadReplica
    @Timed(value="jeap_mes_repository_get_next_message_id", description="Time taken to get next message ID from the DB", percentiles={0.5, 0.8, 0.95, 0.99})
    public Optional<UUID> getNextMessageId(UUID lastMessageId, String bpId, String partnerTopic, String topicName) {
        return this.getNextMessageIdAsString(lastMessageId, bpId, partnerTopic, topicName).map(UUID::fromString);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    @Timed(value="jeap_mes_repository_delete_expired", description="Time taken to delete expired messages", percentiles={0.5, 0.8, 0.95, 0.99})
    public boolean deleteExpiredMessages(int olderThanDays, int limit) {
        return this.jdbcTemplate.update(DELETE_EXPIRED_MESSAGES.formatted(olderThanDays, limit), Map.of()) > 0;
    }

    private Optional<String> getNextMessageIdAsString(UUID lastMessageId, String bpId, String partnerTopic, String topicName) {
        Optional<BigInteger> sequenceId = this.getSequenceId(bpId, lastMessageId.toString());
        if (sequenceId.isPresent()) {
            HashMap<String, Serializable> params = new HashMap<String, Serializable>(Map.of(BP_ID, bpId, SEQUENCE_ID, (Serializable)sequenceId.get()));
            String partnerTopicClause = "";
            String topicNameClause = "";
            if (StringUtils.hasText((String)partnerTopic)) {
                params.put(PARTNER_TOPIC, (Serializable)((Object)partnerTopic));
                partnerTopicClause = "AND t.\"partnerTopic\" = :partnerTopic";
            }
            if (StringUtils.hasText((String)topicName)) {
                params.put(TOPIC_NAME, (Serializable)((Object)topicName));
                topicNameClause = "AND t.\"topicName\" = :topicName";
            }
            return this.jdbcTemplate.queryForList(SELECT_NEXT_MESSAGE_ID_AFTER_SEQUENCE_ID.formatted(partnerTopicClause, topicNameClause), params, String.class).stream().findAny();
        }
        return Optional.empty();
    }

    private Optional<BigInteger> getSequenceId(String bpId, String lastMessageId) {
        Map<String, String> params = Map.of(MESSAGE_ID, lastMessageId, BP_ID, bpId);
        return this.jdbcTemplate.queryForList(SELECT_SEQUENCE_ID_OF_MESSAGE, params, BigInteger.class).stream().findAny();
    }

    @Generated
    public JdbcMessageRepository(NamedParameterJdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

