/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messageexchange.web.api;

import ch.admin.bit.jeap.messageexchange.domain.MessageExchangeService;
import ch.admin.bit.jeap.messageexchange.domain.dto.MessageSearchResultDto;
import ch.admin.bit.jeap.messageexchange.web.api.dto.MessagesResultDto;
import ch.admin.bit.jeap.messageexchange.web.api.exception.InvalidBpIdException;
import ch.admin.bit.jeap.messageexchange.web.api.exception.MissingRequiredHeaderException;
import ch.admin.bit.jeap.messageexchange.web.api.mdc.MessageIdBpIdMdcCloseable;
import ch.admin.bit.jeap.messageexchange.web.api.stream.ControllerStreams;
import ch.admin.bit.jeap.security.resource.semanticAuthentication.ServletSemanticAuthorization;
import io.micrometer.core.annotation.Timed;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Validated
@RequestMapping(value={"/api/partner/v3/messages"})
public class MessagePartnerV3Controller {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessagePartnerV3Controller.class);
    private static final String MESSAGE_ID = "messageId";
    private final MessageExchangeService messageExchangeService;
    private final ControllerStreams controllerStreams;
    private final ServletSemanticAuthorization jeapSemanticAuthorization;

    @PutMapping(value={"/{messageId}"}, consumes={"application/xml"})
    @Operation(summary="Submits a new message", requestBody=@RequestBody(description="XML message", required=true, content={@Content(mediaType="application/xml", schema=@Schema(name="anyxml"))}))
    @PreAuthorize(value="hasRole('b2bmessagein','write')")
    @Timed(value="jeap_mes_partner_controller_send_message", description="Time taken to save a message", percentiles={0.5, 0.8, 0.95, 0.99})
    public ResponseEntity<Void> sendMessage(@PathVariable(value="messageId") @Parameter(description="Unique message identification as UUID: cc7d5097-4d3f-4fff-af91-fd3680199642") UUID messageId, @RequestHeader(value="bp-id") @Parameter(description="Partner identification") String bpId, @RequestHeader(value="message-type") @Parameter(description="Business type definition of the message body") String messageType, HttpServletRequest request) throws InvalidBpIdException, IOException, MissingRequiredHeaderException {
        try (MessageIdBpIdMdcCloseable ignored = MessageIdBpIdMdcCloseable.mdcMessageIdAndBpId(messageId, bpId);){
            this.validateAuthorizedForBpId(bpId, "b2bmessagein", "write");
            log.info("Send new message with messageId {}, bpId {}, messageType {}, size {}", new Object[]{messageId, bpId, messageType, request.getContentLength()});
            this.messageExchangeService.saveNewMessageFromPartner(messageId, bpId, messageType, this.controllerStreams.getRequestContent(request));
            log.debug("Message with messageId {} successfully saved", (Object)messageId);
            ResponseEntity responseEntity = new ResponseEntity((HttpStatusCode)HttpStatus.CREATED);
            return responseEntity;
        }
    }

    @GetMapping(value={""}, produces={"application/xml"})
    @Operation(summary="Returns a list of messages for the given BP (Business Partner), topicName and / or groupId")
    @PreAuthorize(value="hasRole('b2bmessageout','read')")
    @Timed(value="jeap_mes_partner_controller_get_messages", description="Time taken to retrieve a list of messages", percentiles={0.5, 0.8, 0.95, 0.99})
    public MessagesResultDto getMessages(@RequestHeader(value="bp-id") @Parameter(description="Partner identification") String bpId, @RequestParam(value="topicName", required=false) @Parameter(description="Get only messages from given topicName") String topicName, @RequestParam(value="groupId", required=false) @Parameter(description="Get only messages with given groupId") String groupId, @RequestParam(value="lastMessageId", required=false) @Parameter(description="Get only messages which were published after the given messageId") UUID lastMessageId, @RequestParam(value="partnerTopic", required=false) @Parameter(description="Partner Topic") String partnerTopic, @RequestParam(value="size", defaultValue="1000") @Parameter(description="Number of messages returned") int size, HttpServletRequest request) throws InvalidBpIdException {
        return this.getMessages(bpId, topicName, groupId, lastMessageId, partnerTopic, size, request, MessagesResultDto::createV3Dto);
    }

    private MessagesResultDto getMessages(String bpId, String topicName, String groupId, UUID lastMessageId, String partnerTopic, int size, HttpServletRequest request, Function<List<MessageSearchResultDto>, MessagesResultDto> dtoFactory) throws InvalidBpIdException {
        try (MessageIdBpIdMdcCloseable ignored = MessageIdBpIdMdcCloseable.mdcBpId(bpId);){
            this.validateAuthorizedForBpId(bpId, "b2bmessageout", "read");
            log.debug("Get messages with bpId {}, topicName {}, groupId {}, lastMessageId {}, partnerTopic {}, size {}", new Object[]{bpId, topicName, groupId, lastMessageId, partnerTopic, size});
            List searchResults = this.messageExchangeService.getMessages(bpId, topicName, groupId, lastMessageId, partnerTopic, size);
            MessagesResultDto messagesResultDto = dtoFactory.apply(searchResults);
            return messagesResultDto;
        }
    }

    @GetMapping(value={"/{messageId}"}, produces={"application/xml"})
    @Operation(summary="Get message")
    @PreAuthorize(value="hasRole('b2bmessageout','read')")
    @Timed(value="jeap_mes_partner_controller_get_message", description="Time taken to retrieve a message", percentiles={0.5, 0.8, 0.95, 0.99})
    public ResponseEntity<InputStreamResource> getMessage(@PathVariable(value="messageId") @Parameter(description="Unique message identification as UUID: cc7d5097-4d3f-4fff-af91-fd3680199642") UUID messageId, @RequestHeader(value="bp-id") @Parameter(description="Partner identification") String bpId) throws InvalidBpIdException {
        try (MessageIdBpIdMdcCloseable ignored = MessageIdBpIdMdcCloseable.mdcMessageIdAndBpId(messageId, bpId);){
            this.validateAuthorizedForBpId(bpId, "b2bmessageout", "read");
            log.debug("Received get message request for messageId {} and bpId {}", (Object)messageId, (Object)bpId);
            ResponseEntity responseEntity = this.messageExchangeService.getMessageFromInternalApplication(bpId, messageId).map(ControllerStreams::toResponseEntityWithoutResponseHeaders).orElseGet(() -> new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND));
            return responseEntity;
        }
    }

    @GetMapping(value={"/{messageId}/next"}, produces={"application/xml"})
    @Operation(summary="Get next message")
    @PreAuthorize(value="hasRole('b2bmessageout','read')")
    @Timed(value="jeap_mes_partner_controller_get_next_message", description="Time taken to retrieve the next message", percentiles={0.5, 0.8, 0.95, 0.99})
    public ResponseEntity<InputStreamResource> getNextMessage(@PathVariable(value="messageId") @Parameter(description="Unique message identification as UUID: cc7d5097-4d3f-4fff-af91-fd3680199642") UUID lastMessageId, @RequestHeader(value="bp-id") @Parameter(description="Partner identification") String bpId, @RequestParam(value="partnerTopic", required=false) @Parameter(description="Partner Topic") String partnerTopic, @RequestParam(value="topicName", required=false) @Parameter(description="Get only messages from given topicName") String topicName) throws InvalidBpIdException, MissingRequiredHeaderException {
        try (MessageIdBpIdMdcCloseable ignored = MessageIdBpIdMdcCloseable.mdcMessageIdAndBpId(lastMessageId, bpId);){
            this.validateAuthorizedForBpId(bpId, "b2bmessageout", "read");
            log.debug("Received get next message request with lastMessageId {}, bpId {}, partnerTopic {}, topicName {}", new Object[]{lastMessageId, bpId, partnerTopic, topicName});
            ResponseEntity responseEntity = this.messageExchangeService.getNextMessageFromInternalApplication(lastMessageId, bpId, partnerTopic, topicName).map(nextMessageResultDto -> ControllerStreams.toResponseWithMessageIdHeader(nextMessageResultDto.messageContent(), nextMessageResultDto.messageId().toString())).orElseGet(() -> new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND));
            return responseEntity;
        }
    }

    void validateAuthorizedForBpId(String bpId, String resource, String operation) throws InvalidBpIdException {
        if (!StringUtils.hasText((String)bpId)) {
            throw InvalidBpIdException.missingBpId();
        }
        if (!this.jeapSemanticAuthorization.hasRoleForPartner(resource, operation, bpId)) {
            throw InvalidBpIdException.unauthorizedBpId(bpId);
        }
    }

    @Generated
    public MessagePartnerV3Controller(MessageExchangeService messageExchangeService, ControllerStreams controllerStreams, ServletSemanticAuthorization jeapSemanticAuthorization) {
        this.messageExchangeService = messageExchangeService;
        this.controllerStreams = controllerStreams;
        this.jeapSemanticAuthorization = jeapSemanticAuthorization;
    }
}

