/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messageexchange.web.api;

import ch.admin.bit.jeap.messageexchange.web.api.MessageExchangeApiProperties;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.web.firewall.RequestRejectedException;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class ApplicationJsonRequestSizeLimitFilter
extends OncePerRequestFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApplicationJsonRequestSizeLimitFilter.class);
    private final MessageExchangeApiProperties properties;

    protected void doFilterInternal(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull FilterChain filterChain) throws ServletException, IOException {
        if (request.getContentLengthLong() > (long)this.properties.getMaxRequestBodySizeInBytes()) {
            log.warn("Content length {} exceeds the limit of {}", (Object)request.getContentLengthLong(), (Object)this.properties.getMaxRequestBodySizeInBytes());
            throw new RequestRejectedException("Request content exceeded limit of " + this.properties.getMaxRequestBodySizeInBytes() + " bytes");
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    @Generated
    public ApplicationJsonRequestSizeLimitFilter(MessageExchangeApiProperties properties) {
        this.properties = properties;
    }
}

