/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messageexchange.web.api.stream;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import org.springframework.security.web.firewall.RequestRejectedException;

class ZeroCopySizeLimitedByteArrayOutputStream
extends ByteArrayOutputStream {
    private final int maxCapacity;

    ZeroCopySizeLimitedByteArrayOutputStream(int initialCapacity, int maxCapacity) {
        super(initialCapacity);
        this.maxCapacity = maxCapacity;
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) {
        int desiredSize = this.size() + len;
        if (desiredSize > this.maxCapacity) {
            throw new RequestRejectedException("Request content exceeded limit of " + this.maxCapacity + " bytes");
        }
        super.write(b, off, len);
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.buf, 0, this.size());
    }
}

