/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messageexchange.web.api.stream;

import ch.admin.bit.jeap.messageexchange.domain.MessageContent;
import ch.admin.bit.jeap.messageexchange.web.api.MessageExchangeApiProperties;
import ch.admin.bit.jeap.messageexchange.web.api.stream.ZeroCopySizeLimitedByteArrayOutputStream;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class ControllerStreams {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ControllerStreams.class);
    private static final int BUFFER_SIZE = 16384;
    private final MessageExchangeApiProperties properties;

    public static ResponseEntity<InputStreamResource> toResponseEntityWithoutResponseHeaders(MessageContent messageContent) {
        return ResponseEntity.ok().contentLength((long)messageContent.contentLength()).body((Object)new InputStreamResource(messageContent.inputStream()));
    }

    public static ResponseEntity<InputStreamResource> toResponseIncludingLegacyMessageIdHeader(MessageContent messageContent, String messageId) {
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Messageid", new String[]{messageId})).header("message-id", new String[]{messageId})).contentLength((long)messageContent.contentLength()).body((Object)new InputStreamResource(messageContent.inputStream()));
    }

    public static ResponseEntity<InputStreamResource> toResponseWithMessageIdHeader(MessageContent messageContent, String messageId) {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("message-id", new String[]{messageId})).contentLength((long)messageContent.contentLength()).body((Object)new InputStreamResource(messageContent.inputStream()));
    }

    public MessageContent getRequestContent(HttpServletRequest request) throws IOException {
        int contentLength = request.getContentLength();
        if (contentLength != -1) {
            return new MessageContent((InputStream)request.getInputStream(), contentLength);
        }
        return this.readRequestOfUnknownLengthToByteArray(request);
    }

    private MessageContent readRequestOfUnknownLengthToByteArray(HttpServletRequest request) throws IOException {
        log.info("No content length given - fully reading request");
        try (ServletInputStream inputStream = request.getInputStream();){
            ZeroCopySizeLimitedByteArrayOutputStream buffer = new ZeroCopySizeLimitedByteArrayOutputStream(16384, this.properties.getMaxRequestBodySizeInBytes());
            inputStream.transferTo((OutputStream)buffer);
            MessageContent messageContent = new MessageContent(buffer.getInputStream(), buffer.size());
            return messageContent;
        }
    }

    @Generated
    public ControllerStreams(MessageExchangeApiProperties properties) {
        this.properties = properties;
    }
}

