/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messageexchange.web.api;

import ch.admin.bit.jeap.messageexchange.domain.Message;
import ch.admin.bit.jeap.messageexchange.domain.MessageExchangeService;
import ch.admin.bit.jeap.messageexchange.web.api.LegacyHeaderHelper;
import ch.admin.bit.jeap.messageexchange.web.api.exception.MissingRequiredHeaderException;
import ch.admin.bit.jeap.messageexchange.web.api.mdc.MessageIdBpIdMdcCloseable;
import ch.admin.bit.jeap.messageexchange.web.api.stream.ControllerStreams;
import io.micrometer.core.annotation.Timed;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/internal/v2/messages"})
@Validated
public class MessageInternalController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageInternalController.class);
    private final MessageExchangeService messageExchangeService;
    private final ControllerStreams controllerStreams;

    @PutMapping(value={"/{messageId}"}, consumes={"application/xml"})
    @Operation(summary="Sends a new message to a business partner", requestBody=@RequestBody(description="XML message", required=true, content={@Content(mediaType="application/xml", schema=@Schema(name="anyxml"))}))
    @PreAuthorize(value="hasRole('b2bmessageout','write')")
    @Timed(value="jeap_mes_internal_controller_send_message", description="Time taken to send a message", percentiles={0.5, 0.8, 0.95, 0.99})
    public ResponseEntity<Void> sendMessage(@PathVariable(value="messageId") @Parameter(description="Message identification as UUID 12345678-1234-1234-1234-123456789012") UUID messageId, @RequestHeader(value="bp-id", required=false) @Parameter(description="Receiving partner identification") String bpId, @RequestHeader(value="bpId", required=false) @Parameter(description="Receiving partner identification") String bpIdOld, @RequestParam(value="topicName") @Parameter(description="Publish the message into a certain topic") String topicName, @RequestParam(value="groupId", required=false) @Parameter(description="Grouping identifier to group multiple messages") String groupId, @RequestHeader(value="message-type", required=false) @Parameter(description="Business type definition of the message body") String messageType, @RequestHeader(value="messageType", required=false) @Parameter(description="Business type definition of the message body") String messageTypeOld, @RequestHeader(value="partner-topic", required=false) @Parameter(description="Partner Topic") String partnerTopic, @RequestHeader(value="partnerTopic", required=false) @Parameter(description="Partner Topic") String partnerTopicOld, HttpServletRequest request) throws IOException, MissingRequiredHeaderException {
        bpId = LegacyHeaderHelper.checkVariables(bpId, bpIdOld, "bpId", "bp-id", true);
        messageType = LegacyHeaderHelper.checkVariables(messageType, messageTypeOld, "messageType", "message-type", true);
        partnerTopic = LegacyHeaderHelper.checkVariables(partnerTopic, partnerTopicOld, "partnerTopic", "partner-topic", false);
        try (MessageIdBpIdMdcCloseable ignored = MessageIdBpIdMdcCloseable.mdcMessageIdAndBpId(messageId, bpId);){
            Message message = Message.builder().messageId(messageId).bpId(bpId).topicName(topicName).groupId(groupId).messageType(messageType).partnerTopic(partnerTopic).build();
            log.info("Send new message {} with size {} to partner", (Object)message, (Object)request.getContentLength());
            this.messageExchangeService.saveNewMessageFromInternalApplication(message, this.controllerStreams.getRequestContent(request));
            log.debug("Message with messageId {} successfully saved", (Object)messageId);
            ResponseEntity responseEntity = new ResponseEntity((HttpStatusCode)HttpStatus.CREATED);
            return responseEntity;
        }
    }

    @GetMapping(value={"/{messageId}"}, produces={"application/xml"})
    @Operation(summary="Receive a message from a partner with the messageId", responses={@ApiResponse(responseCode="403", description="Not delivering because of the malware scan status")})
    @PreAuthorize(value="hasRole('b2bmessagein','read')")
    @Timed(value="jeap_mes_internal_controller_get_message", description="Time taken to retrieve a message", percentiles={0.5, 0.8, 0.95, 0.99})
    public ResponseEntity<InputStreamResource> getMessage(@PathVariable(value="messageId") @Parameter(description="Message identification as UUID 12345678-1234-1234-1234-123456789012") UUID messageId) {
        try (MessageIdBpIdMdcCloseable ignored = MessageIdBpIdMdcCloseable.mdcMessageId(messageId);){
            log.debug("Received get message request for messageId {}", (Object)messageId);
            ResponseEntity responseEntity = this.messageExchangeService.getMessageFromPartner(messageId).map(ControllerStreams::toResponseEntityWithoutResponseHeaders).orElseGet(() -> new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND));
            return responseEntity;
        }
    }

    @Generated
    public MessageInternalController(MessageExchangeService messageExchangeService, ControllerStreams controllerStreams) {
        this.messageExchangeService = messageExchangeService;
        this.controllerStreams = controllerStreams;
    }
}

