/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messageexchange.web.api;

import ch.admin.bit.jeap.messageexchange.domain.exception.MalwareScanFailedOrBlockedException;
import ch.admin.bit.jeap.messageexchange.domain.xml.InvalidXMLInputException;
import ch.admin.bit.jeap.messageexchange.web.api.exception.InvalidBpIdException;
import ch.admin.bit.jeap.messageexchange.web.api.exception.MissingRequiredHeaderException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@RestControllerAdvice
public class RestResponseExceptionHandler
extends ResponseEntityExceptionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RestResponseExceptionHandler.class);

    @ExceptionHandler(value={InvalidXMLInputException.class})
    public ResponseEntity<String> handleInvalidXMLInputException(InvalidXMLInputException ex) {
        log.warn("Invalid XML input provided for messageId {} and bpId {}", new Object[]{ex.getMessageId(), ex.getBpId(), ex});
        return ResponseEntity.badRequest().body((Object)("Invalid XML input provided: " + ex.getMessage()));
    }

    @ExceptionHandler(value={InvalidBpIdException.class})
    public ResponseEntity<String> handleInvalidBpIdException(InvalidBpIdException ex) {
        log.warn("Invalid BP ID: {}", (Object)ex.getMessage());
        return ResponseEntity.status((int)403).body((Object)"bpId in token does not match bpId in header");
    }

    @ExceptionHandler(value={MalwareScanFailedOrBlockedException.class})
    public ResponseEntity<String> handleMalwareScanNotDeliveringException(MalwareScanFailedOrBlockedException ex) {
        return ResponseEntity.status((int)403).body((Object)"Not delivering because of malware scan status");
    }

    @ExceptionHandler(value={MissingRequiredHeaderException.class})
    public ResponseEntity<String> handleMissingRequiredHeaderException(MissingRequiredHeaderException ex) {
        log.warn("Missing required header: {}", (Object)ex.getMessage());
        return ResponseEntity.status((int)400).body((Object)ex.getMessage());
    }
}

