/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.avro.plugin.compiler;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ImportClassLoader
extends URLClassLoader {
    private final Map<String, URL> importFiles = new HashMap<String, URL>();

    public ImportClassLoader() {
        super(new URL[0], Thread.currentThread().getContextClassLoader());
    }

    public ImportClassLoader(File sourceDirectory) throws MalformedURLException {
        super(ImportClassLoader.convertToUrlList(sourceDirectory, Collections.emptyList()), Thread.currentThread().getContextClassLoader());
    }

    public ImportClassLoader(File sourceDirectory, List<String> classpathElements) throws MalformedURLException {
        super(ImportClassLoader.convertToUrlList(sourceDirectory, classpathElements), Thread.currentThread().getContextClassLoader());
    }

    public ImportClassLoader(ImportClassLoader importClassLoader, File commonRootDir, File commonSystemDir) {
        super(new URL[0], (ClassLoader)importClassLoader);
        File file;
        if (commonRootDir.exists()) {
            for (String filename : Objects.requireNonNull(commonRootDir.list())) {
                file = new File(commonRootDir, filename);
                this.addImportFile(filename, file);
            }
        }
        if (commonSystemDir.exists()) {
            for (String filename : Objects.requireNonNull(commonSystemDir.list())) {
                file = new File(commonSystemDir, filename);
                this.addImportFile(filename, file);
            }
        }
    }

    private static URL[] convertToUrlList(File sourceDirectory, List<String> classpathElements) throws MalformedURLException {
        ArrayList<URL> runtimeUrls = new ArrayList<URL>();
        if (sourceDirectory != null) {
            runtimeUrls.add(sourceDirectory.toURI().toURL());
        }
        for (String runtimeClasspathElement : classpathElements) {
            runtimeUrls.add(new File(runtimeClasspathElement).toURI().toURL());
        }
        return runtimeUrls.toArray(new URL[0]);
    }

    public void addImportFile(String filename, File file) {
        this.importFiles.put(filename, file.toURI().toURL());
    }

    @Override
    public URL findResource(String name) {
        if (this.importFiles.containsKey(name)) {
            return this.importFiles.get(name);
        }
        URL resource = super.findResource(name);
        if (resource != null) {
            return resource;
        }
        return this.getParent().getResource(name);
    }

    public String toString() {
        return "ImportClassLoader{importFiles=" + String.valueOf(this.importFiles) + "}";
    }
}

