/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.avro.errorevent;

import ch.admin.bit.jeap.domainevent.avro.AvroDomainEventBuilder;
import ch.admin.bit.jeap.messaging.avro.AvroMessageBuilderException;
import ch.admin.bit.jeap.messaging.avro.SerializedMessageHolder;
import ch.admin.bit.jeap.messaging.avro.errorevent.CausingMessageMetadata;
import ch.admin.bit.jeap.messaging.avro.errorevent.ErrorTypeReference;
import ch.admin.bit.jeap.messaging.avro.errorevent.FailedMessageMetadata;
import ch.admin.bit.jeap.messaging.avro.errorevent.MessageHandlerExceptionInformation;
import ch.admin.bit.jeap.messaging.avro.errorevent.MessageProcessingFailedEvent;
import ch.admin.bit.jeap.messaging.avro.errorevent.MessageProcessingFailedPayload;
import ch.admin.bit.jeap.messaging.avro.errorevent.MessageProcessingFailedReferences;
import ch.admin.bit.jeap.messaging.avro.errorevent.MessageReference;
import ch.admin.bit.jeap.messaging.model.Message;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageProcessingFailedEventBuilder
extends AvroDomainEventBuilder<MessageProcessingFailedEventBuilder, MessageProcessingFailedEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageProcessingFailedEventBuilder.class);
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.wrap("EMPTY_CONTENT".getBytes());
    private final String eventName = "MessageProcessingFailedEvent";
    private final String specifiedMessageTypeVersion = "1.0.0";
    private String serviceName;
    private String systemName;
    private ConsumerRecord<?, ?> originalMessage;
    private MessageHandlerExceptionInformation messageHandlerExceptionInformation;
    private String processId = null;
    private CausingMessageMetadata causingMessageMetadata;
    private int stackTraceMaxLength;
    private String stackTraceHash;

    private MessageProcessingFailedEventBuilder() {
        super(MessageProcessingFailedEvent::new);
    }

    public static MessageProcessingFailedEventBuilder create() {
        return new MessageProcessingFailedEventBuilder();
    }

    public MessageProcessingFailedEventBuilder originalMessage(ConsumerRecord<?, ?> originalMessage, String ... preservedHeaderNames) {
        this.originalMessage = originalMessage;
        Object recordValue = originalMessage.value();
        if (recordValue instanceof Message) {
            Message msg = (Message)recordValue;
            this.processId = msg.getOptionalProcessId().orElse(null);
            this.causingMessageMetadata = CausingMessageMetadata.from(msg, originalMessage.headers(), preservedHeaderNames);
        }
        return this.self();
    }

    public MessageProcessingFailedEventBuilder eventHandleException(MessageHandlerExceptionInformation messageHandlerExceptionInformation) {
        this.messageHandlerExceptionInformation = messageHandlerExceptionInformation;
        return this.self();
    }

    public MessageProcessingFailedEventBuilder systemName(String systemName) {
        this.systemName = systemName;
        return this.self();
    }

    public MessageProcessingFailedEventBuilder serviceName(String serviceName) {
        this.serviceName = serviceName;
        return this.self();
    }

    public MessageProcessingFailedEventBuilder stackTraceMaxLength(int stackTraceMaxLength) {
        this.stackTraceMaxLength = stackTraceMaxLength;
        return this.self();
    }

    public MessageProcessingFailedEventBuilder stackTraceHash(String stackTraceHash) {
        this.stackTraceHash = stackTraceHash;
        return this.self();
    }

    protected MessageProcessingFailedEventBuilder self() {
        return this;
    }

    public MessageProcessingFailedEvent build() {
        if (this.originalMessage == null) {
            throw AvroMessageBuilderException.propertyNull((String)"errorReferences.message");
        }
        if (this.messageHandlerExceptionInformation == null) {
            throw AvroMessageBuilderException.propertyNull((String)"errorReferences.exception");
        }
        ErrorTypeReference errorType = ErrorTypeReference.newBuilder().setCode(this.messageHandlerExceptionInformation.getErrorCode()).setTemporality(this.messageHandlerExceptionInformation.getTemporality().toString()).setType("exception").build();
        MessageReference messageReference = MessageReference.newBuilder().setOffset(String.valueOf(this.originalMessage.offset())).setPartition(String.valueOf(this.originalMessage.partition())).setTopicName(this.originalMessage.topic()).setType("message").build();
        MessageProcessingFailedReferences errorReferences = MessageProcessingFailedReferences.newBuilder().setMessage(messageReference).setErrorType(errorType).build();
        MessageProcessingFailedPayload errorPayload = MessageProcessingFailedPayload.newBuilder().setErrorMessage(this.messageHandlerExceptionInformation.getMessage()).setOriginalKey(this.getSerializedMessage(this.originalMessage.key(), null)).setOriginalMessage(this.getSerializedMessage(this.originalMessage.value(), EMPTY_BUFFER)).setStackTrace(this.truncateStackTrace(this.messageHandlerExceptionInformation.getStackTraceAsString())).setStackTraceHash(this.stackTraceHash).setErrorDescription(this.messageHandlerExceptionInformation.getDescription()).setFailedMessageMetadata(this.buildFailedMessageMetadata()).build();
        this.setPayload(errorPayload);
        this.setReferences(errorReferences);
        this.setProcessId(this.processId);
        this.idempotenceId(UUID.randomUUID().toString());
        return (MessageProcessingFailedEvent)super.build();
    }

    private String truncateStackTrace(String stacktrace) {
        if (stacktrace == null || stacktrace.length() <= this.stackTraceMaxLength) {
            return stacktrace;
        }
        return stacktrace.substring(0, this.stackTraceMaxLength) + "...";
    }

    private FailedMessageMetadata buildFailedMessageMetadata() {
        if (this.causingMessageMetadata == null) {
            return null;
        }
        return FailedMessageMetadata.newBuilder().setCreated(this.causingMessageMetadata.created()).setEventId(this.causingMessageMetadata.eventId()).setIdempotenceId(this.causingMessageMetadata.idempotenceId()).setService(this.causingMessageMetadata.service()).setSystem(this.causingMessageMetadata.system()).setMessageTypeName(this.causingMessageMetadata.messageTypeName()).setMessageTypeVersion(this.causingMessageMetadata.messageTypeVersion()).setHeaders(this.causingMessageMetadata.headers()).build();
    }

    private ByteBuffer getSerializedMessage(Object obj, ByteBuffer defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        if (obj instanceof SerializedMessageHolder) {
            SerializedMessageHolder smh = (SerializedMessageHolder)obj;
            return Optional.ofNullable(smh.getSerializedMessage()).map(ByteBuffer::wrap).orElse(defaultValue);
        }
        if (obj instanceof byte[]) {
            byte[] bytes = (byte[])obj;
            return ByteBuffer.wrap(bytes);
        }
        log.error("Could not get serialized message from type " + String.valueOf(obj.getClass()));
        return defaultValue;
    }

    @Generated
    public String getEventName() {
        return this.eventName;
    }

    @Generated
    public String getSpecifiedMessageTypeVersion() {
        return this.specifiedMessageTypeVersion;
    }

    @Generated
    public String getServiceName() {
        return this.serviceName;
    }

    @Generated
    public String getSystemName() {
        return this.systemName;
    }
}

