/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.avro.errorevent;

import ch.admin.bit.jeap.messaging.model.Message;
import ch.admin.bit.jeap.messaging.model.MessageIdentity;
import ch.admin.bit.jeap.messaging.model.MessagePublisher;
import ch.admin.bit.jeap.messaging.model.MessageType;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;

record CausingMessageMetadata(String eventId, String idempotenceId, Instant created, String system, String service, String messageTypeName, String messageTypeVersion, Map<String, ByteBuffer> headers) {
    static CausingMessageMetadata from(Message message, Headers headers, String ... preservedHeaderNames) {
        Map<String, ByteBuffer> headerMap = CausingMessageMetadata.createHeaderMap(headers, preservedHeaderNames);
        MessageIdentity identity = message.getIdentity();
        MessagePublisher publisher = message.getPublisher();
        MessageType type = message.getType();
        return new CausingMessageMetadata(identity != null ? identity.getId() : null, identity != null ? identity.getIdempotenceId() : null, identity != null ? identity.getCreated() : null, publisher != null ? publisher.getSystem() : null, publisher != null ? publisher.getService() : null, type != null ? type.getName() : null, type != null ? type.getVersion() : null, headerMap);
    }

    private static Map<String, ByteBuffer> createHeaderMap(Headers headers, String[] preservedHeaderNames) {
        HashMap<String, ByteBuffer> headerMap = new HashMap<String, ByteBuffer>();
        for (String headerName : preservedHeaderNames) {
            Header header = headers.lastHeader(headerName);
            if (header == null) continue;
            byte[] headerValue = header.value();
            headerMap.put(headerName, ByteBuffer.wrap(headerValue));
        }
        return headerMap;
    }
}

