/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.avro.plugin.helper;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.MavenInvocationException;

public class MavenDeployer {
    private final Log log;
    private final String mavenDeployGoal;
    private final boolean parallel;
    private final String mavenExecutable;
    private final String mavenGlobalSettingsFile;
    private final String profile;

    public MavenDeployer(Log log, String mavenDeployGoal, boolean parallel, String mavenExecutable, String mavenGlobalSettingsFile, String profile) {
        this.log = log;
        this.mavenDeployGoal = mavenDeployGoal;
        this.parallel = parallel;
        this.mavenExecutable = mavenExecutable;
        this.mavenGlobalSettingsFile = mavenGlobalSettingsFile;
        this.profile = profile;
    }

    public List<InvocationResult> deployProjects(List<Path> poms) {
        if (poms.isEmpty()) {
            return List.of();
        }
        ExecutorService executorService = Executors.newFixedThreadPool(this.parallel ? 1 : 10);
        Path path = poms.getFirst();
        poms = poms.subList(1, poms.size());
        InvocationRequest invocationRequest = this.toInvocationRequest(path);
        ArrayList<InvocationResult> results = new ArrayList<InvocationResult>();
        InvocationResult firstResult = MavenDeployer.awaitAndGetResult(this.runMavenInvoker(executorService, invocationRequest));
        results.add(firstResult);
        poms.stream().map(this::toInvocationRequest).map(r -> this.runMavenInvoker(executorService, (InvocationRequest)r)).map(MavenDeployer::awaitAndGetResult).forEach(results::add);
        this.log.info((CharSequence)("Executed " + results.size() + " tasks"));
        return results;
    }

    private static InvocationResult awaitAndGetResult(Future<InvocationResult> r) {
        try {
            return r.get();
        }
        catch (ExecutionException ex) {
            throw ex.getCause();
        }
    }

    private Future<InvocationResult> runMavenInvoker(ExecutorService executorService, InvocationRequest request) {
        this.log.info((CharSequence)"Executing maven request for pom %s: mnv=%s args=%s profiles=%s goals=%s props=%s".formatted(request.getPomFile(), this.getMavenExecutable(), request.getArgs(), request.getProfiles() == null ? "" : request.getProfiles(), request.getGoals(), request.getProperties()));
        return executorService.submit(() -> this.executeRequest(request));
    }

    private InvocationResult executeRequest(InvocationRequest request) {
        Invoker invoker = this.createInvoker();
        try {
            InvocationResult result = invoker.execute(request);
            if (result.getExitCode() != 0) {
                throw new MojoExecutionException("Build failed with exitCode " + result.getExitCode());
            }
            return result;
        }
        catch (MavenInvocationException e) {
            throw new MojoExecutionException("Error during Maven Invocation: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    Invoker createInvoker() {
        return new DefaultInvoker();
    }

    private InvocationRequest toInvocationRequest(Path pomPath) {
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setBatchMode(true);
        request.setPomFile(pomPath.toFile());
        request.setMavenExecutable(this.getMavenExecutable());
        request.setGlobalSettingsFile(this.getMavenGlobalSettingsFile());
        if (this.profile != null) {
            request.setProfiles(List.of(this.profile));
        }
        request.setGoals(List.of(this.mavenDeployGoal));
        Properties properties = new Properties();
        properties.setProperty("maven.test.skip", "true");
        properties.setProperty("style.color", "always");
        properties.setProperty("jansi.force", "true");
        Map<String, String> proxyProperties = System.getProperties().entrySet().stream().filter(e -> e.getKey().toString().matches("^http.*[pP]roxy.*$")).collect(Collectors.toMap(e -> e.getKey().toString(), e -> e.getValue().toString()));
        properties.putAll(proxyProperties);
        request.setProperties(properties);
        return request;
    }

    private File getMavenExecutable() {
        if (!StringUtils.isBlank((CharSequence)this.mavenExecutable) && Files.exists(Path.of(this.mavenExecutable, new String[0]), new LinkOption[0])) {
            return Path.of(this.mavenExecutable, new String[0]).toFile();
        }
        return Paths.get(Paths.get("", new String[0]).toAbsolutePath().toString(), "mvnw").toFile();
    }

    private File getMavenGlobalSettingsFile() {
        if (!StringUtils.isBlank((CharSequence)this.mavenGlobalSettingsFile) && Files.exists(Path.of(this.mavenGlobalSettingsFile, new String[0]), new LinkOption[0])) {
            return Path.of(this.mavenGlobalSettingsFile, new String[0]).toFile();
        }
        return Paths.get(Paths.get("", new String[0]).toAbsolutePath().toString(), "settings.xml").toFile();
    }
}

