/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.avro.plugin.mojo;

import ch.admin.bit.jeap.messaging.avro.plugin.compiler.AvroCompiler;
import ch.admin.bit.jeap.messaging.avro.plugin.compiler.IdlFileParser;
import ch.admin.bit.jeap.messaging.avro.plugin.compiler.ImportClassLoader;
import ch.admin.bit.jeap.messaging.avro.plugin.interfaces.InterfaceTool;
import ch.admin.bit.jeap.messaging.avro.plugin.validator.RecordCollection;
import ch.admin.bit.jeap.messaging.avro.plugin.validator.SchemaValidator;
import ch.admin.bit.jeap.messaging.avro.plugin.validator.ValidationResult;
import java.io.File;
import java.io.IOException;
import lombok.Generated;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.compiler.idl.ParseException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;

public abstract class AbstractAvroMojo
extends AbstractMojo {
    @Parameter(name="sourceDirectory", defaultValue="${basedir}/src/main/avro")
    private File sourceDirectory;
    @Parameter(name="outputDirectory", defaultValue="${project.build.directory}/generated-sources")
    private File outputDirectory;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(name="deleteBaseEventFiles", defaultValue="true")
    private boolean deleteBaseEventFiles = true;
    @Parameter(defaultValue="false")
    private boolean enableDecimalLogicalType;
    private ValidationResult overallResult = ValidationResult.ok();

    public void execute() throws MojoExecutionException {
        this.ensureDirectoryExists(this.sourceDirectory);
        String sourceEncoding = this.project.getProperties().getProperty("project.build.sourceEncoding");
        InterfaceTool interfaceTool = new InterfaceTool();
        AvroCompiler avroCompiler = AvroCompiler.builder().sourceEncoding(sourceEncoding).outputDirectory(this.outputDirectory).additionalTool(interfaceTool).enableDecimalLogicalType(this.enableDecimalLogicalType).build();
        for (String filename : this.getIncludedFiles()) {
            File file = new File(this.sourceDirectory, filename);
            this.compile(avroCompiler, file);
        }
        if (this.deleteBaseEventFiles) {
            avroCompiler.deleteBaseEventFiles();
        }
        this.project.addCompileSourceRoot(this.outputDirectory.getAbsolutePath());
        if (!this.overallResult.isValid()) {
            throw new MojoExecutionException("At least one avro schema is not a valid message. Check log for details");
        }
    }

    private void ensureDirectoryExists(File sourceDirectory) throws MojoExecutionException {
        boolean hasSourceDir;
        boolean bl = hasSourceDir = null != sourceDirectory && sourceDirectory.isDirectory();
        if (!hasSourceDir) {
            throw new MojoExecutionException("sourceDirectory: " + String.valueOf(sourceDirectory) + " is a directory");
        }
    }

    private String[] getIncludedFiles() {
        FileSetManager fileSetManager = new FileSetManager();
        FileSet fs = new FileSet();
        fs.setDirectory(this.sourceDirectory.getAbsolutePath());
        fs.setFollowSymlinks(false);
        for (String include : this.getIncludedFileEndings()) {
            fs.addInclude("**/*." + include);
        }
        return fileSetManager.getIncludedFiles(fs);
    }

    protected abstract String[] getIncludedFileEndings();

    protected abstract void compile(AvroCompiler var1, File var2) throws MojoExecutionException;

    void compileIdl(AvroCompiler avroCompiler, File file, ImportClassLoader importClassLoader) throws MojoExecutionException {
        try {
            IdlFileParser idlFileParser = new IdlFileParser(importClassLoader);
            Protocol protocol = idlFileParser.parseIdlFile(file);
            if (this.isValid(RecordCollection.of((Protocol)protocol), file)) {
                this.getLog().debug((CharSequence)("Compile protocol " + protocol.getName() + "from IDL file " + file.getAbsolutePath()));
                protocol.getTypes().forEach(t -> this.getLog().debug((CharSequence)("Type " + t.getName() + " is in this record")));
                avroCompiler.compileProtocol(protocol, null);
            }
        }
        catch (IOException | ParseException e) {
            throw this.compileException((Exception)e, file);
        }
    }

    void compileSchema(AvroCompiler avroCompiler, File file) throws MojoExecutionException {
        try {
            Schema.Parser parser = new Schema.Parser();
            Schema schema = parser.parse(file);
            if (this.isValid(RecordCollection.of((Schema)schema), file)) {
                this.getLog().debug((CharSequence)("Compile schema " + schema.getName() + "from schema file " + file.getAbsolutePath()));
                avroCompiler.compileSchema(schema, file);
            }
        }
        catch (IOException e) {
            throw this.compileException(e, file);
        }
    }

    void compileProtocol(AvroCompiler avroCompiler, File file) throws MojoExecutionException {
        try {
            Protocol protocol = Protocol.parse((File)file);
            if (this.isValid(RecordCollection.of((Protocol)protocol), file)) {
                this.getLog().debug((CharSequence)("Compile protocol " + protocol.getName() + "from protocol file " + file.getAbsolutePath()));
                protocol.getTypes().forEach(t -> this.getLog().debug((CharSequence)("Type " + t.getName() + " is in this record")));
                avroCompiler.compileProtocol(protocol, file);
            }
        }
        catch (IOException e) {
            throw this.compileException(e, file);
        }
    }

    private MojoExecutionException compileException(Exception e, File file) {
        return new MojoExecutionException("Could not compile file " + file.getAbsolutePath(), e);
    }

    private boolean isValid(RecordCollection recordCollection, File src) {
        ValidationResult result = SchemaValidator.validate((RecordCollection)recordCollection);
        if (!result.isValid()) {
            result.getErrors().stream().map(e -> "In file " + src.getAbsolutePath() + ": " + e).forEach(arg_0 -> ((Log)this.getLog()).error(arg_0));
        }
        this.overallResult = ValidationResult.merge((ValidationResult[])new ValidationResult[]{result, this.overallResult});
        return result.isValid();
    }

    @Generated
    protected AbstractAvroMojo() {
    }

    @Generated
    protected File getSourceDirectory() {
        return this.sourceDirectory;
    }

    @Generated
    protected MavenProject getProject() {
        return this.project;
    }

    @Generated
    protected boolean isEnableDecimalLogicalType() {
        return this.enableDecimalLogicalType;
    }
}

