/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.avro.plugin.compiler;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.compiler.specific.SpecificCompiler;
import org.apache.avro.generic.GenericData;
import org.apache.maven.plugin.MojoExecutionException;

public class AvroCompiler {
    private static final Path MESSAGING_PACKAGE_PATH = Path.of("ch", "admin", "bit", "jeap", "messaging", "avro");
    private static final Path DOMAINEVENT_PACKAGE_PATH = Path.of("ch", "admin", "bit", "jeap", "domainevent", "avro");
    private static final Set<Path> JEAP_MESSAGING_FILES = Set.of(DOMAINEVENT_PACKAGE_PATH.resolve("AvroDomainEventType.java"), DOMAINEVENT_PACKAGE_PATH.resolve("AvroDomainEventIdentity.java"), DOMAINEVENT_PACKAGE_PATH.resolve("AvroDomainEventPublisher.java"), DOMAINEVENT_PACKAGE_PATH.resolve("AvroDomainEventUser.java"), MESSAGING_PACKAGE_PATH.resolve("AvroMessageType.java"), MESSAGING_PACKAGE_PATH.resolve("AvroMessageIdentity.java"), MESSAGING_PACKAGE_PATH.resolve("AvroMessagePublisher.java"), MESSAGING_PACKAGE_PATH.resolve("AvroMessageUser.java"));
    private static final String TEMPLATE_DIRECTORY = "/velocity-templates/";
    private final String sourceEncoding;
    private final File outputDirectory;
    private final List<Object> additionalTools;
    private final boolean enableDecimalLogicalType;

    public void compileSchema(Schema schema, File onlyIfFileChanged) throws IOException {
        SpecificCompiler compiler = new SpecificCompiler(schema);
        this.configureCompiler(compiler);
        compiler.compileToDestination(onlyIfFileChanged, this.outputDirectory);
    }

    public void compileProtocol(Protocol protocol, File onlyIfFileChanged) throws IOException {
        SpecificCompiler compiler = new SpecificCompiler(protocol);
        this.configureCompiler(compiler);
        compiler.compileToDestination(onlyIfFileChanged, this.outputDirectory);
    }

    private void configureCompiler(SpecificCompiler compiler) {
        compiler.setStringType(GenericData.StringType.String);
        compiler.setTemplateDir(TEMPLATE_DIRECTORY);
        compiler.setFieldVisibility(SpecificCompiler.FieldVisibility.PRIVATE);
        compiler.setCreateOptionalGetters(true);
        compiler.setGettersReturnOptional(false);
        compiler.setCreateSetters(true);
        compiler.setAdditionalVelocityTools(this.additionalTools);
        compiler.setEnableDecimalLogicalType(this.enableDecimalLogicalType);
        compiler.setOutputCharacterEncoding(this.sourceEncoding);
    }

    public void deleteBaseEventFiles() throws MojoExecutionException {
        if (!this.outputDirectory.exists()) {
            return;
        }
        try (Stream<Path> stream = Files.walk(this.outputDirectory.toPath(), Integer.MAX_VALUE, new FileVisitOption[0]);){
            List<Path> allFiles = stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).toList();
            block7: for (Path current : allFiles) {
                for (Path jeapFile : JEAP_MESSAGING_FILES) {
                    if (!current.endsWith(jeapFile)) continue;
                    Files.deleteIfExists(current);
                    continue block7;
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot delete base event files", (Exception)e);
        }
    }

    @Generated
    public static AvroCompilerBuilder builder() {
        return new AvroCompilerBuilder();
    }

    @Generated
    public AvroCompilerBuilder toBuilder() {
        AvroCompilerBuilder builder = new AvroCompilerBuilder().sourceEncoding(this.sourceEncoding).outputDirectory(this.outputDirectory).enableDecimalLogicalType(this.enableDecimalLogicalType);
        if (this.additionalTools != null) {
            builder.additionalTools(this.additionalTools);
        }
        return builder;
    }

    @Generated
    private AvroCompiler(String sourceEncoding, File outputDirectory, List<Object> additionalTools, boolean enableDecimalLogicalType) {
        this.sourceEncoding = sourceEncoding;
        this.outputDirectory = outputDirectory;
        this.additionalTools = additionalTools;
        this.enableDecimalLogicalType = enableDecimalLogicalType;
    }

    @Generated
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Generated
    public static class AvroCompilerBuilder {
        @Generated
        private String sourceEncoding;
        @Generated
        private File outputDirectory;
        @Generated
        private ArrayList<Object> additionalTools;
        @Generated
        private boolean enableDecimalLogicalType;

        @Generated
        AvroCompilerBuilder() {
        }

        @Generated
        public AvroCompilerBuilder sourceEncoding(String sourceEncoding) {
            this.sourceEncoding = sourceEncoding;
            return this;
        }

        @Generated
        public AvroCompilerBuilder outputDirectory(File outputDirectory) {
            this.outputDirectory = outputDirectory;
            return this;
        }

        @Generated
        public AvroCompilerBuilder additionalTool(Object additionalTool) {
            if (this.additionalTools == null) {
                this.additionalTools = new ArrayList();
            }
            this.additionalTools.add(additionalTool);
            return this;
        }

        @Generated
        public AvroCompilerBuilder additionalTools(Collection<? extends Object> additionalTools) {
            if (additionalTools == null) {
                throw new NullPointerException("additionalTools cannot be null");
            }
            if (this.additionalTools == null) {
                this.additionalTools = new ArrayList();
            }
            this.additionalTools.addAll(additionalTools);
            return this;
        }

        @Generated
        public AvroCompilerBuilder clearAdditionalTools() {
            if (this.additionalTools != null) {
                this.additionalTools.clear();
            }
            return this;
        }

        @Generated
        public AvroCompilerBuilder enableDecimalLogicalType(boolean enableDecimalLogicalType) {
            this.enableDecimalLogicalType = enableDecimalLogicalType;
            return this;
        }

        @Generated
        public AvroCompiler build() {
            return new AvroCompiler(this.sourceEncoding, this.outputDirectory, switch (this.additionalTools == null ? 0 : this.additionalTools.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.additionalTools.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Object>(this.additionalTools));
            }, this.enableDecimalLogicalType);
        }

        @Generated
        public String toString() {
            return "AvroCompiler.AvroCompilerBuilder(sourceEncoding=" + this.sourceEncoding + ", outputDirectory=" + String.valueOf(this.outputDirectory) + ", additionalTools=" + String.valueOf(this.additionalTools) + ", enableDecimalLogicalType=" + this.enableDecimalLogicalType + ")";
        }
    }
}

