/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.avro.plugin.mojo;

import ch.admin.bit.jeap.messaging.avro.plugin.helper.MavenDeployer;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="deploy-message-type-artifacts", requiresDependencyResolution=ResolutionScope.RUNTIME, defaultPhase=LifecyclePhase.DEPLOY, threadSafe=true)
public class MessageTypeArtifactsDeployerMojo
extends AbstractMojo {
    public static final String POM_XML_FILE_NAME = "pom.xml";
    @Parameter(name="sourcesDirectory", defaultValue="${project.build.directory}/generated-sources")
    private File sourcesDirectory;
    @Parameter(name="mavenDeployGoal", defaultValue="install")
    private String mavenDeployGoal;
    @Parameter(name="mavenExecutable")
    private String mavenExecutable;
    @Parameter(name="mavenGlobalSettingsFile")
    private String mavenGlobalSettingsFile;
    @Parameter(name="currentBranch", defaultValue="${git.branch}", required=true)
    private String currentBranch;
    @Parameter(name="trunkBranchName", defaultValue="master", required=true)
    private String trunkBranchName;
    @Parameter(name="trunkMavenProfile")
    private String trunkMavenProfile;
    @Parameter(name="parallel", defaultValue="false")
    private boolean parallel;

    public void execute() throws MojoExecutionException {
        if (!this.sourcesDirectory.exists()) {
            return;
        }
        String profile = this.isBuildOnTrunk() ? this.trunkMavenProfile : null;
        MavenDeployer deployer = new MavenDeployer(this.getLog(), this.mavenDeployGoal, this.parallel, this.mavenExecutable, this.mavenGlobalSettingsFile, profile);
        this.deployCommonLibraries(deployer);
        this.deployLibraries(deployer);
    }

    private void deployCommonLibraries(MavenDeployer deployer) throws MojoExecutionException {
        try (Stream<Path> walk = Files.walk(Paths.get(this.sourcesDirectory.getAbsolutePath(), new String[0]), Integer.MAX_VALUE, new FileVisitOption[0]);){
            List<Path> poms = walk.filter(path -> this.isCommonLibrary((Path)path) && path.toString().endsWith(POM_XML_FILE_NAME)).collect(Collectors.toList());
            this.getLog().info((CharSequence)("Deploying " + poms.size() + " common maven projects."));
            deployer.deployProjects(poms);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot parse the output directory for the pom.xml: " + e.getMessage(), (Exception)e);
        }
    }

    private void deployLibraries(MavenDeployer deployer) throws MojoExecutionException {
        try (Stream<Path> walk = Files.walk(Paths.get(this.sourcesDirectory.getAbsolutePath(), new String[0]), Integer.MAX_VALUE, new FileVisitOption[0]);){
            List<Path> poms = walk.filter(path -> !this.isCommonLibrary((Path)path) && path.toString().endsWith(POM_XML_FILE_NAME)).collect(Collectors.toList());
            this.getLog().info((CharSequence)("Deploying " + poms.size() + " maven projects."));
            deployer.deployProjects(poms);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot parse the output directory for the pom.xml: " + e.getMessage(), (Exception)e);
        }
    }

    private boolean isCommonLibrary(Path path) {
        return path.toString().contains("_common");
    }

    private boolean isBuildOnTrunk() {
        return this.trunkBranchName.equals(this.currentBranch);
    }

    @Generated
    public void setCurrentBranch(String currentBranch) {
        this.currentBranch = currentBranch;
    }

    @Generated
    public void setTrunkBranchName(String trunkBranchName) {
        this.trunkBranchName = trunkBranchName;
    }

    @Generated
    public void setTrunkMavenProfile(String trunkMavenProfile) {
        this.trunkMavenProfile = trunkMavenProfile;
    }
}

