/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.avro.plugin.helper;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import org.apache.commons.text.StringSubstitutor;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public class PomFileGenerator {
    public static final String POM_XML_FILE_NAME = "pom.xml";
    private final Path outputPath;
    private final File pomTemplateFile;
    private final Log log;

    public PomFileGenerator(Path outputPath, File pomTemplateFile, Log log) {
        this.outputPath = outputPath;
        this.pomTemplateFile = pomTemplateFile;
        this.log = log;
    }

    public void generatePomFile(String groupId, String artefactId, String dependency, String version, String jeapMessagingVersion) throws MojoExecutionException {
        try {
            String pomContent = this.getPomXmlContent(groupId, artefactId, dependency, version, jeapMessagingVersion);
            Path path = Paths.get(this.outputPath.toString(), POM_XML_FILE_NAME);
            Files.createDirectories(this.outputPath, new FileAttribute[0]);
            Files.writeString(path, (CharSequence)pomContent, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot write pom.xml to directory: " + e.getMessage(), (Exception)e);
        }
    }

    private String getPomXmlContent(String groupId, String artifactId, String dependency, String version, String jeapMessagingVersion) throws IOException {
        String pomTemplate = this.loadPomTemplate();
        pomTemplate = pomTemplate.replace("<!-- ${dependency} -->", "${dependency}");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("groupId", groupId);
        params.put("artifactId", artifactId);
        params.put("dependency", dependency);
        params.put("version", version);
        params.put("jeapMessagingVersion", jeapMessagingVersion);
        return StringSubstitutor.replace((Object)pomTemplate, params);
    }

    private String loadPomTemplate() throws IOException {
        try (InputStream resourceAsStream = this.openPomTemplateStream();){
            byte[] content = resourceAsStream.readAllBytes();
            String string = new String(content);
            return string;
        }
    }

    private InputStream openPomTemplateStream() throws IOException {
        if (this.pomTemplateFile != null) {
            if (!this.pomTemplateFile.isFile()) {
                throw new IllegalArgumentException("Messagetype pom.xml template file does not exist at %s".formatted(this.pomTemplateFile.getAbsolutePath()));
            }
            this.log.info((CharSequence)("Using pom template at " + String.valueOf(this.pomTemplateFile) + " to generate " + String.valueOf(this.outputPath)));
            return new FileInputStream(this.pomTemplateFile);
        }
        this.log.info((CharSequence)("Using built-in pom template file to generate " + String.valueOf(this.outputPath)));
        return PomFileGenerator.class.getClassLoader().getResourceAsStream("pom.template.messagetype.xml");
    }

    public static String getCommonDependency(String groupId, String artifactId, String version) {
        String template = "<dependency>\n    <groupId>${groupId}</groupId>\n    <artifactId>${artifactId}-messaging-common</artifactId>\n    <version>${version}</version>\n</dependency>";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("groupId", groupId);
        params.put("artifactId", artifactId);
        params.put("version", version);
        return StringSubstitutor.replace((Object)template, params);
    }
}

