/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.avro.plugin.interfaces;

import ch.admin.bit.jeap.domainevent.DomainEventIdentity;
import ch.admin.bit.jeap.messaging.model.MessageIdentity;
import ch.admin.bit.jeap.messaging.model.MessagePayload;
import ch.admin.bit.jeap.messaging.model.MessagePublisher;
import ch.admin.bit.jeap.messaging.model.MessageReferences;
import ch.admin.bit.jeap.messaging.model.MessageType;
import ch.admin.bit.jeap.messaging.model.MessageUser;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.apache.avro.Schema;
import org.apache.avro.specific.SpecificRecord;

class InterfaceList {
    private final List<String> interfaceNames = new LinkedList<String>();

    private static String create(@NonNull Schema schema) {
        if (schema == null) {
            throw new NullPointerException("schema is marked non-null but is null");
        }
        InterfaceList interfaceList = new InterfaceList();
        interfaceList.addAvroInterfaces(schema);
        interfaceList.addBaseTypesInterfaces(schema);
        interfaceList.addCustomTypesInterfaces(schema);
        return interfaceList.toString();
    }

    private void addAvroInterfaces(Schema schema) {
        this.addClass(SpecificRecord.class);
        if (schema.getName().endsWith("Event")) {
            this.addName("ch.admin.bit.jeap.domainevent.avro.AvroDomainEvent");
        }
        if (schema.getName().endsWith("Command")) {
            this.addName("ch.admin.bit.jeap.command.avro.AvroCommand");
        }
        if (schema.getName().endsWith("MessageKey")) {
            this.addName("ch.admin.bit.jeap.messaging.avro.AvroMessageKey");
        }
    }

    private void addBaseTypesInterfaces(Schema schema) {
        if (schema.getName().endsWith("AvroDomainEventIdentity")) {
            this.addClass(DomainEventIdentity.class);
        }
        if (schema.getName().endsWith("AvroDomainEventType")) {
            this.addClass(MessageType.class);
        }
        if (schema.getName().endsWith("AvroDomainEventPublisher")) {
            this.addClass(MessagePublisher.class);
        }
        if (schema.getName().endsWith("AvroDomainEventUser")) {
            this.addClass(MessageUser.class);
        }
        if (schema.getName().endsWith("AvroMessageIdentity")) {
            this.addClass(MessageIdentity.class);
        }
        if (schema.getName().endsWith("AvroMessageType")) {
            this.addClass(MessageType.class);
        }
        if (schema.getName().endsWith("AvroMessagePublisher")) {
            this.addClass(MessagePublisher.class);
        }
        if (schema.getName().endsWith("AvroMessageUser")) {
            this.addClass(MessageUser.class);
        }
    }

    private void addCustomTypesInterfaces(Schema schema) {
        if (schema.getName().endsWith("References")) {
            this.addClass(MessageReferences.class);
        }
        if (schema.getName().endsWith("Payload")) {
            this.addClass(MessagePayload.class);
        }
    }

    private void addClass(Class<?> klass) {
        this.addName(klass.getCanonicalName());
    }

    private void addName(String name) {
        this.interfaceNames.add(name);
    }

    public String toString() {
        return String.join((CharSequence)", ", this.interfaceNames);
    }

    @Generated
    public static StringBuilder builder() {
        return new StringBuilder();
    }

    @Generated
    private InterfaceList() {
    }

    @Generated
    public static class StringBuilder {
        @Generated
        private Schema schema;

        @Generated
        StringBuilder() {
        }

        @Generated
        public StringBuilder schema(@NonNull Schema schema) {
            if (schema == null) {
                throw new NullPointerException("schema is marked non-null but is null");
            }
            this.schema = schema;
            return this;
        }

        @Generated
        public String build() {
            return InterfaceList.create(this.schema);
        }

        @Generated
        public String toString() {
            return "InterfaceList.StringBuilder(schema=" + String.valueOf(this.schema) + ")";
        }
    }
}

