/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.avro.plugin.mojo;

import ch.admin.bit.jeap.messaging.avro.plugin.compiler.AvroCompiler;
import ch.admin.bit.jeap.messaging.avro.plugin.compiler.ImportClassLoader;
import ch.admin.bit.jeap.messaging.avro.plugin.mojo.AbstractAvroMojo;
import java.io.File;
import java.io.IOException;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="idl", requiresDependencyResolution=ResolutionScope.RUNTIME, defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true)
public class IDLProtocolMojo
extends AbstractAvroMojo {
    @Override
    protected String[] getIncludedFileEndings() {
        return new String[]{"avdl"};
    }

    @Override
    protected void compile(AvroCompiler avroCompiler, File file) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Compile IDL file " + file.getAbsolutePath()));
        try (ImportClassLoader importClassLoader = new ImportClassLoader(this.getSourceDirectory(), this.getProject().getRuntimeClasspathElements());){
            this.compileIdl(avroCompiler, file, importClassLoader);
        }
        catch (IOException | DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Cannot create classpath loader", (Exception)e);
        }
    }
}

