/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.avro.plugin.mojo;

import ch.admin.bit.jeap.messaging.avro.plugin.compiler.AvroCompiler;
import ch.admin.bit.jeap.messaging.avro.plugin.compiler.IdlFileParser;
import ch.admin.bit.jeap.messaging.avro.plugin.compiler.ImportClassLoader;
import ch.admin.bit.jeap.messaging.avro.plugin.git.GitClient;
import ch.admin.bit.jeap.messaging.avro.plugin.git.GitDiffDto;
import ch.admin.bit.jeap.messaging.avro.plugin.git.NewMessageTypeVersionDto;
import ch.admin.bit.jeap.messaging.avro.plugin.helper.GeneratedSourcesCleaner;
import ch.admin.bit.jeap.messaging.avro.plugin.helper.PomFileGenerator;
import ch.admin.bit.jeap.messaging.avro.plugin.helper.RegistryHelper;
import ch.admin.bit.jeap.messaging.avro.plugin.helper.TypeDescriptorFactory;
import ch.admin.bit.jeap.messaging.avro.plugin.interfaces.InterfaceTool;
import ch.admin.bit.jeap.messaging.avro.plugin.registry.TypeDescriptor;
import ch.admin.bit.jeap.messaging.avro.plugin.registry.TypeVersion;
import ch.admin.bit.jeap.messaging.avro.plugin.registry.metadata.MessageTypeMetadata;
import ch.admin.bit.jeap.messaging.avro.plugin.registry.metadata.MessageTypeMetadataProvider;
import ch.admin.bit.jeap.messaging.avro.plugin.registry.service.MessageSchema;
import ch.admin.bit.jeap.messaging.avro.plugin.registry.service.TypeReference;
import ch.admin.bit.jeap.messaging.avro.plugin.validator.RecordCollection;
import ch.admin.bit.jeap.messaging.avro.plugin.validator.SchemaValidator;
import ch.admin.bit.jeap.messaging.avro.plugin.validator.ValidationResult;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.avro.Protocol;
import org.apache.avro.compiler.idl.ParseException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="compile-message-types", requiresDependencyResolution=ResolutionScope.RUNTIME, defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true)
public class MessageTypesCompilerMojo
extends AbstractMojo {
    private final String commonLibVersion;
    private final GeneratedSourcesCleaner generatedSourcesCleaner = new GeneratedSourcesCleaner();
    @Parameter(name="sourceDirectory", defaultValue="${basedir}/descriptor")
    private File sourceDirectory;
    @Parameter(name="outputDirectory", defaultValue="${project.build.directory}/generated-sources")
    private File outputDirectory;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(name="generateAllMessageTypes", defaultValue="false")
    private boolean generateAllMessageTypes;
    @Parameter(name="groupIdPrefix", required=true)
    private String groupIdPrefix;
    @Parameter(name="jeapMessagingVersion", defaultValue="${jeap-messaging.version}", required=true)
    private String jeapMessagingVersion;
    @Parameter(name="currentBranch", defaultValue="${git.branch}", required=true)
    private String currentBranch;
    @Parameter(name="commitId", defaultValue="${git.commit.id}", required=true)
    private String commitId;
    @Parameter(name="gitUrl", required=true)
    private String gitUrl;
    @Parameter(name="trunkBranchName", defaultValue="master", required=true)
    private String trunkBranchName;
    @Parameter(name="pomTemplateFile")
    private File pomTemplateFile;
    @Parameter(name="skip", defaultValue="false", required=true)
    private boolean skip;
    @Parameter(defaultValue="false")
    private boolean enableDecimalLogicalType;
    private Map<String, List<Path>> commonDefinitionsPerSystem = new HashMap<String, List<Path>>();
    private ValidationResult overallResult = ValidationResult.ok();

    public MessageTypesCompilerMojo() {
        this.commonLibVersion = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy.MM.dd.HH.mm.ss"));
    }

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Message type compilation is skipped");
            return;
        }
        this.getLog().info((CharSequence)("Current Branch: " + this.currentBranch));
        String sourceEncoding = this.project.getProperties().getProperty("project.build.sourceEncoding");
        AvroCompiler avroCompiler = AvroCompiler.builder().sourceEncoding(sourceEncoding).outputDirectory(this.outputDirectory).additionalTool(new InterfaceTool()).enableDecimalLogicalType(this.enableDecimalLogicalType).build();
        GitClient gitClient = new GitClient(this.project.getBasedir().getAbsolutePath(), this.trunkBranchName);
        if (this.generateAllMessageTypes) {
            this.compile(avroCompiler);
        } else {
            GitDiffDto gitDiff = gitClient.getGitDiff(this.currentBranch);
            if (gitDiff.hasChanges()) {
                this.getLog().info((CharSequence)("New messages types since compared commit: " + this.newTypes(gitDiff.newMessageTypeVersions())));
                this.compile(avroCompiler, gitDiff);
            } else {
                this.getLog().info((CharSequence)"No changes from compared commit. Skipping compile...");
            }
        }
        this.generatedSourcesCleaner.cleanupDuplicatedCommonFiles(this.outputDirectory, this.commonDefinitionsPerSystem);
        avroCompiler.deleteBaseEventFiles();
        this.project.addCompileSourceRoot(this.outputDirectory.getAbsolutePath());
        if (!this.overallResult.isValid()) {
            throw new MojoExecutionException("At least one avro schema is not a valid message. Check log for details");
        }
    }

    private String newTypes(Set<NewMessageTypeVersionDto> newMessageTypeVersionDtos) {
        return newMessageTypeVersionDtos.stream().map(Record::toString).collect(Collectors.joining("\n", "\n", ""));
    }

    private void compile(AvroCompiler avroCompiler) throws MojoExecutionException {
        this.commonDefinitionsPerSystem = this.retrieveCommonDefinitionsGroupedBySystem();
        this.compileCommonSchemas(avroCompiler, Set.of());
        this.compileSchemas(avroCompiler, this.retrieveSchemas(this.retrieveDescriptors()));
    }

    private void compile(AvroCompiler avroCompiler, GitDiffDto gitDiff) throws MojoExecutionException {
        this.commonDefinitionsPerSystem = this.retrieveCommonDefinitionsGroupedBySystem();
        this.compileCommonSchemas(avroCompiler, gitDiff.systems());
        this.compileSchemas(avroCompiler, this.retrieveSchemasForNewMessageTypeVersions(gitDiff.newMessageTypeVersions()));
    }

    private List<MessageSchema> retrieveSchemasForNewMessageTypeVersions(Set<NewMessageTypeVersionDto> newMessageTypeVersions) throws MojoExecutionException {
        ArrayList<MessageSchema> list = new ArrayList<MessageSchema>();
        for (NewMessageTypeVersionDto dto : newMessageTypeVersions) {
            list.addAll(this.retrieveSchemasForNewMessageTypeVersion(dto.descriptorPath(), dto.typeDescriptor(), dto.version()));
        }
        return list;
    }

    private List<MessageSchema> retrieveSchemasForNewMessageTypeVersion(Path descriptorPath, TypeDescriptor typeDescriptor, String newVersion) throws MojoExecutionException {
        ArrayList<MessageSchema> schemas = new ArrayList<MessageSchema>();
        this.addValueSchema(descriptorPath, typeDescriptor, newVersion, schemas);
        this.addKeySchema(descriptorPath, typeDescriptor, newVersion, schemas);
        return schemas;
    }

    private void addValueSchema(Path descriptorPath, TypeDescriptor typeDescriptor, String newVersion, List<MessageSchema> schemas) throws MojoExecutionException {
        Optional<TypeVersion> typeVersionValueSchema = typeDescriptor.getVersions().stream().filter(v -> v.getVersion().equals(newVersion)).findFirst();
        if (typeVersionValueSchema.isPresent()) {
            TypeVersion version = typeVersionValueSchema.get();
            schemas.add(this.descriptorToMessageSchema(MessageTypesCompilerMojo.schemaFile(descriptorPath, version.getValueSchema()), typeDescriptor, version));
        }
    }

    private void addKeySchema(Path descriptorPath, TypeDescriptor typeDescriptor, String newVersion, List<MessageSchema> schemas) throws MojoExecutionException {
        TypeVersion version;
        Optional<TypeVersion> typeVersionKeySchema = typeDescriptor.getVersions().stream().filter(v -> v.getKeySchema() != null && v.getVersion().equals(newVersion)).findFirst();
        if (typeVersionKeySchema.isPresent() && this.compileKeySchema(version = typeVersionKeySchema.get())) {
            schemas.add(this.descriptorToMessageSchema(MessageTypesCompilerMojo.schemaFile(descriptorPath, version.getKeySchema()), typeDescriptor, version));
        }
    }

    private static File schemaFile(Path descriptorPath, String schemaFile) {
        return new File(descriptorPath.getParent().toFile(), schemaFile);
    }

    private Map<String, List<Path>> retrieveCommonDefinitionsGroupedBySystem() throws MojoExecutionException {
        Map<String, List<Path>> map;
        block8: {
            Stream<Path> stream = Files.walk(Paths.get(this.sourceDirectory.getAbsolutePath(), new String[0]), Integer.MAX_VALUE, new FileVisitOption[0]);
            try {
                map = stream.filter(path -> path.toString().contains("_common") && FilenameUtils.getExtension((String)path.getFileName().toString()).equals("avdl")).collect(Collectors.groupingBy(file -> file.getParent().getParent().getFileName().toString(), Collectors.mapping(file -> file, Collectors.toList())));
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Cannot walk through the source directory", (Exception)e);
                }
            }
            stream.close();
        }
        return map;
    }

    private void compileCommonSchemas(AvroCompiler avroCompiler, Set<String> changedSystemsToCompile) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Compile common schemas for " + this.commonDefinitionsPerSystem.size() + " systems"));
        for (Map.Entry<String, List<Path>> entry : this.commonDefinitionsPerSystem.entrySet()) {
            if (!changedSystemsToCompile.isEmpty() && !changedSystemsToCompile.contains(entry.getKey())) {
                this.getLog().info((CharSequence)("... System " + entry.getKey() + " not changed. Skipping..."));
                continue;
            }
            List<MessageSchema> schemas = entry.getValue().stream().map(commonFile -> this.commonSchemaToMessageSchema(commonFile.toFile(), (String)entry.getKey(), commonFile.getFileName().toString(), RegistryHelper.retrieveVersionFromCommonDefinition(commonFile.toString()))).toList();
            for (MessageSchema schema : schemas) {
                this.getLog().debug((CharSequence)("Compile common schema: " + schema.getSchema().getAbsolutePath()));
                Path outputPath = Paths.get(avroCompiler.getOutputDirectory().getAbsolutePath(), this.retrieveTypeReference(schema).getDefiningSystem(), "_common");
                this.compileSchema(outputPath, avroCompiler, schema);
            }
            Path outputPath = Paths.get(avroCompiler.getOutputDirectory().getAbsolutePath(), entry.getKey(), "_common");
            PomFileGenerator pomFileGenerator = new PomFileGenerator(outputPath, this.pomTemplateFile, this.getLog());
            pomFileGenerator.generatePomFile(this.getGroupIdPrefixWithTrailingDot() + entry.getKey().toLowerCase(Locale.ROOT), entry.getKey() + "-messaging-common", "", this.getCommonLibVersionAsProjectVersion(), this.jeapMessagingVersion);
            this.getLog().info((CharSequence)("+++ Compiled " + entry.getValue().size() + " common schemas for system " + entry.getKey()));
        }
    }

    private String getGroupIdPrefixWithTrailingDot() {
        return this.groupIdPrefix.endsWith(".") ? this.groupIdPrefix : this.groupIdPrefix + ".";
    }

    private TypeReference retrieveTypeReference(MessageSchema schema) throws MojoExecutionException {
        Optional<TypeReference> typeReference = schema.getTypeReference();
        if (typeReference.isPresent()) {
            return typeReference.get();
        }
        throw new MojoExecutionException("TypeReference is empty but must be present");
    }

    private Map<String, File> retrieveCommonFilesForSystem(String systemName) throws MojoExecutionException {
        Map<String, File> map;
        block9: {
            Path systemCommonDirectoryPath = Paths.get(this.sourceDirectory.getAbsolutePath(), systemName.toLowerCase(), "_common");
            if (!Files.exists(systemCommonDirectoryPath, new LinkOption[0])) {
                return Collections.emptyMap();
            }
            Stream<Path> stream = Files.walk(systemCommonDirectoryPath, Integer.MAX_VALUE, new FileVisitOption[0]);
            try {
                map = stream.filter(file -> FilenameUtils.getExtension((String)file.getFileName().toString()).equals("avdl")).collect(Collectors.toMap(filepath -> filepath.getFileName().toString(), Path::toFile));
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Cannot get the common files: " + e.getMessage(), (Exception)e);
                }
            }
            stream.close();
        }
        return map;
    }

    private List<Path> retrieveDescriptors() throws MojoExecutionException {
        List<Path> list;
        block8: {
            Stream<Path> stream = Files.walk(Paths.get(this.sourceDirectory.getAbsolutePath(), new String[0]), Integer.MAX_VALUE, new FileVisitOption[0]);
            try {
                list = stream.filter(f -> FilenameUtils.getExtension((String)f.getFileName().toString()).equals("json")).toList();
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Cannot walk through the sourceDirectory: " + e.getMessage(), (Exception)e);
                }
            }
            stream.close();
        }
        return list;
    }

    private MessageSchema commonSchemaToMessageSchema(File schemaFile, String system, String messageName, String version) {
        return MessageSchema.builder().schema(schemaFile).typeReference(new TypeReference(system, messageName, version)).importPath(Map.of()).build();
    }

    private MessageSchema descriptorToMessageSchema(File schemaFile, TypeDescriptor typeDescriptor, TypeVersion version) throws MojoExecutionException {
        MessageTypeMetadata messageTypeMetadata = MessageTypeMetadataProvider.createMessageTypeMetadata(typeDescriptor, version, this.currentBranch, this.commitId, this.gitUrl);
        return MessageSchema.builder().schema(schemaFile).messageTypeMetadata(messageTypeMetadata).typeReference(new TypeReference(typeDescriptor.getDefiningSystem(), typeDescriptor.getName(), version.getVersion())).importPath(this.retrieveCommonFilesForSystem(typeDescriptor.getDefiningSystem())).build();
    }

    private List<MessageSchema> retrieveSchemas(List<Path> descriptors) throws MojoExecutionException {
        ArrayList<MessageSchema> schemas = new ArrayList<MessageSchema>();
        for (Path descriptor : descriptors) {
            schemas.addAll(this.retrieveSchemasForDescriptor(descriptor, TypeDescriptorFactory.getTypeDescriptor(descriptor)));
        }
        return schemas;
    }

    private List<MessageSchema> retrieveSchemasForDescriptor(Path descriptor, TypeDescriptor typeDescriptor) throws MojoExecutionException {
        ArrayList<MessageSchema> schemas = new ArrayList<MessageSchema>();
        for (TypeVersion version : typeDescriptor.getVersions()) {
            schemas.add(this.descriptorToMessageSchema(MessageTypesCompilerMojo.schemaFile(descriptor, version.getValueSchema()), typeDescriptor, version));
            if (!this.compileKeySchema(version)) continue;
            schemas.add(this.descriptorToMessageSchema(MessageTypesCompilerMojo.schemaFile(descriptor, version.getKeySchema()), typeDescriptor, version));
        }
        return schemas;
    }

    private boolean compileKeySchema(TypeVersion version) {
        return version.getKeySchema() != null && !version.getKeySchema().startsWith("ch.");
    }

    private void compileSchemas(AvroCompiler avroCompiler, List<MessageSchema> schemas) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Compiling " + schemas.size() + " schemas"));
        for (MessageSchema schema : schemas) {
            this.getLog().debug((CharSequence)("Compile schema " + schema.getSchema().getAbsolutePath()));
            TypeReference typeReference = this.retrieveTypeReference(schema);
            Path outputPath = Paths.get(avroCompiler.getOutputDirectory().getAbsolutePath(), typeReference.getDefiningSystem().toLowerCase(Locale.ROOT), typeReference.getName(), typeReference.getVersion());
            String groupId = this.getGroupIdPrefixWithTrailingDot() + typeReference.getDefiningSystem().toLowerCase(Locale.ROOT);
            PomFileGenerator pomFileGenerator = new PomFileGenerator(outputPath, this.pomTemplateFile, this.getLog());
            pomFileGenerator.generatePomFile(groupId, this.camelCase2Snake(typeReference.getName()), this.getDependencyDefinition(typeReference), this.getArtifactVersion(typeReference.getVersion()), this.jeapMessagingVersion);
            this.compileSchema(outputPath, avroCompiler, schema);
        }
        this.getLog().info((CharSequence)"Compiled all schemas");
    }

    private String getDependencyDefinition(TypeReference typeReference) {
        String dependency = "";
        if (this.commonLibAvailableForSystem(typeReference.getDefiningSystem())) {
            String groupId = this.getGroupIdPrefixWithTrailingDot() + typeReference.getDefiningSystem().toLowerCase(Locale.ROOT);
            dependency = PomFileGenerator.getCommonDependency(groupId, typeReference.getDefiningSystem().toLowerCase(Locale.ROOT), this.getCommonLibVersionAsDependencyVersion());
        }
        return dependency;
    }

    private void compileSchema(Path outputPath, AvroCompiler avroCompiler, MessageSchema messageSchema) throws MojoExecutionException {
        AvroCompiler.AvroCompilerBuilder avroCompilerBuilder = avroCompiler.toBuilder().outputDirectory(Paths.get(outputPath.toString(), "src", "main", "java").toFile());
        messageSchema.getMessageTypeMetadata().ifPresent(avroCompilerBuilder::additionalTool);
        avroCompiler = avroCompilerBuilder.build();
        try (ImportClassLoader importClassLoader = this.getImportClassLoader(messageSchema);){
            this.compileIdl(avroCompiler, messageSchema.getSchema(), importClassLoader);
        }
        catch (IOException | DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Cannot create classpath loader: " + e.getMessage(), (Exception)e);
        }
    }

    private String getArtifactVersion(String typeReferenceVersion) {
        if (this.isBuildOnTrunk()) {
            return typeReferenceVersion;
        }
        return String.format("%s-%s-SNAPSHOT", typeReferenceVersion, this.getSanitizedCurrentBranchName());
    }

    private String getCommonLibVersionAsDependencyVersion() {
        if (this.isBuildOnTrunk()) {
            return "[0,)";
        }
        return this.getCommonLibSnapshotVersion();
    }

    private String getCommonLibVersionAsProjectVersion() {
        if (this.isBuildOnTrunk()) {
            return this.commonLibVersion;
        }
        return this.getCommonLibSnapshotVersion();
    }

    private boolean isBuildOnTrunk() {
        return this.trunkBranchName.equals(this.currentBranch);
    }

    private String getCommonLibSnapshotVersion() {
        return String.format("%s-%s-SNAPSHOT", this.commonLibVersion, this.getSanitizedCurrentBranchName());
    }

    private String getSanitizedCurrentBranchName() {
        return this.currentBranch.replaceAll("[^A-Za-z0-9-_]", "_");
    }

    private boolean commonLibAvailableForSystem(String definingSystem) {
        return this.commonDefinitionsPerSystem.containsKey(definingSystem.toLowerCase(Locale.ROOT));
    }

    private ImportClassLoader getImportClassLoader(MessageSchema messageSchema) throws IOException, DependencyResolutionRequiredException {
        ImportClassLoader importClassLoader = new ImportClassLoader(this.sourceDirectory, this.project.getRuntimeClasspathElements());
        for (String filename : messageSchema.getImportPath().keySet()) {
            importClassLoader.addImportFile(filename, messageSchema.getImportPath().get(filename));
        }
        return importClassLoader;
    }

    private void compileIdl(AvroCompiler avroCompiler, File file, ImportClassLoader importClassLoader) throws MojoExecutionException {
        try {
            IdlFileParser idlFileParser = new IdlFileParser(importClassLoader);
            Protocol protocol = idlFileParser.parseIdlFile(file);
            if (this.isValid(RecordCollection.of((Protocol)protocol), file)) {
                this.getLog().debug((CharSequence)("Compile protocol " + protocol.getName() + " from IDL file " + file.getAbsolutePath()));
                protocol.getTypes().forEach(t -> this.getLog().debug((CharSequence)("Type " + t.getName() + " is in this record")));
                avroCompiler.compileProtocol(protocol, null);
            }
        }
        catch (IOException | ParseException e) {
            throw this.compileException((Exception)e, file);
        }
    }

    private MojoExecutionException compileException(Exception e, File file) {
        return new MojoExecutionException("Could not compile file " + file.getAbsolutePath(), e);
    }

    private boolean isValid(RecordCollection recordCollection, File src) {
        ValidationResult result = SchemaValidator.validate((RecordCollection)recordCollection);
        if (!result.isValid()) {
            result.getErrors().stream().map(e -> "In file " + src.getAbsolutePath() + ": " + e).forEach(arg_0 -> ((Log)this.getLog()).error(arg_0));
        }
        this.overallResult = ValidationResult.merge((ValidationResult[])new ValidationResult[]{result, this.overallResult});
        return result.isValid();
    }

    private String camelCase2Snake(String input) {
        if (StringUtils.isBlank((CharSequence)input)) {
            return input;
        }
        return input.replaceAll("([A-Z])", "-$1").replaceFirst("^-", "").toLowerCase();
    }

    @Generated
    public void setGenerateAllMessageTypes(boolean generateAllMessageTypes) {
        this.generateAllMessageTypes = generateAllMessageTypes;
    }

    @Generated
    public void setGroupIdPrefix(String groupIdPrefix) {
        this.groupIdPrefix = groupIdPrefix;
    }

    @Generated
    public void setCurrentBranch(String currentBranch) {
        this.currentBranch = currentBranch;
    }

    @Generated
    public void setCommitId(String commitId) {
        this.commitId = commitId;
    }

    @Generated
    public void setGitUrl(String gitUrl) {
        this.gitUrl = gitUrl;
    }

    @Generated
    public void setTrunkBranchName(String trunkBranchName) {
        this.trunkBranchName = trunkBranchName;
    }

    @Generated
    public void setPomTemplateFile(File pomTemplateFile) {
        this.pomTemplateFile = pomTemplateFile;
    }

    @Generated
    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    @Generated
    protected boolean isEnableDecimalLogicalType() {
        return this.enableDecimalLogicalType;
    }
}

